/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.SimplifiedDAPUtils;
import com.digiwin.app.merge.enums.DevModeEnum;
import com.digiwin.app.merge.pojo.SourceAppInfo;
import com.digiwin.app.merge.pojo.SourceSimplifiedAppInfo;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PropertiesProcessor {
    private static final Logger log = LogManager.getLogger(PropertiesProcessor.class);
    static final String APPLICATION_PROPERTIES_PATH = "develop/conf/application.properties";

    PropertiesProcessor() {
    }

    public static Properties loadProperties(MergeAppContext context, SourceAppInfo appInfo) {
        Properties result = null;
        Path path = DevModeEnum.SIMPLIFIED == context.getDevMode() ? SimplifiedDAPUtils.getDevelopConfApplicationPropertiesPath((SourceSimplifiedAppInfo)appInfo) : Paths.get(context.getWorkspace(), appInfo.getRootDir(), APPLICATION_PROPERTIES_PATH);
        if (Files.exists(path, new LinkOption[0])) {
            String filePath = path.toFile().getAbsolutePath();
            try (FileInputStream fis = new FileInputStream(filePath);){
                result = new Properties();
                result.load(fis);
            }
            catch (IOException e) {
                log.error("\u8b80\u53d6properties\u51fa\u932f\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
        }
        return result;
    }

    public static String getProperty(MergeAppContext context, SourceAppInfo appInfo, String key) {
        String result = null;
        Properties properties = PropertiesProcessor.loadProperties(context, appInfo);
        if (Objects.nonNull(properties)) {
            result = properties.getProperty(key);
        }
        return result;
    }

    public static String getProperty(Path filePath, String key) {
        String result = null;
        Properties properties = new Properties();
        try {
            properties.load(Files.newInputStream(filePath, new OpenOption[0]));
            result = properties.getProperty(key);
        }
        catch (IOException e) {
            log.error("\u8b80\u53d6properties\u51fa\u932f\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }
}

