/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.SimplifiedDAPUtils;
import com.digiwin.app.merge.enums.DevModeEnum;
import com.digiwin.app.merge.pojo.SourceAppInfo;
import com.digiwin.app.merge.pojo.SourceSimplifiedAppInfo;
import com.digiwin.app.merge.processor.PropertiesProcessor;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SourceAppProcessor {
    private static final Logger log = LogManager.getLogger(SourceAppProcessor.class);

    private SourceAppProcessor() {
    }

    public static Map<String, SourceAppInfo> readSourceApps(MergeAppContext context) {
        String workspace = context.getWorkspace();
        LinkedHashMap<String, SourceAppInfo> result = new LinkedHashMap<String, SourceAppInfo>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(workspace, new String[0]), "*");){
            ArrayList<String> rootDirList = new ArrayList<String>();
            for (Path entry : stream) {
                String app;
                if (!Files.isDirectory(entry, new LinkOption[0]) || "dap-merged-app".equalsIgnoreCase(app = entry.getFileName().toString())) continue;
                rootDirList.add(app);
            }
            rootDirList.forEach(dir -> result.put((String)dir, SourceAppProcessor.createSourceAppInfo(context, dir)));
        }
        catch (Exception e) {
            log.error("9,\u8b80\u53d6\u4f86\u6e90\u61c9\u7528\u7d50\u69cb\u6642\u51fa\u932f\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    private static SourceAppInfo createSourceAppInfo(MergeAppContext context, String appSourceCodeFolderName) {
        String error;
        SourceAppInfo sourceAppInfo;
        if (context.getDevMode() == DevModeEnum.MODULAR) {
            sourceAppInfo = new SourceAppInfo(appSourceCodeFolderName, appSourceCodeFolderName.equalsIgnoreCase(context.getTargetAppFolderName()));
        } else {
            sourceAppInfo = new SourceSimplifiedAppInfo(appSourceCodeFolderName, appSourceCodeFolderName.equalsIgnoreCase(context.getTargetAppFolderName()));
            ((SourceSimplifiedAppInfo)sourceAppInfo).setBackendPath(SimplifiedDAPUtils.getBackendPath(context, appSourceCodeFolderName));
        }
        String appId = PropertiesProcessor.getProperty(context, sourceAppInfo, "appId");
        String iamApToken = PropertiesProcessor.getProperty(context, sourceAppInfo, "iamApToken");
        String placeHolder = "@appId@";
        if (placeHolder.equalsIgnoreCase(appId)) {
            error = "appId \u6c92\u6709\u66f4\u63db\u70ba\u5be6\u969b\u503c, \u4f54\u4f4d\u7b26: " + placeHolder;
            sourceAppInfo.addError(error);
        }
        if ((placeHolder = "@iamApToken@").equalsIgnoreCase(iamApToken)) {
            error = "iamApToken \u6c92\u6709\u66f4\u63db\u70ba\u5be6\u969b\u503c, \u4f54\u4f4d\u7b26: " + placeHolder;
            sourceAppInfo.addError(error);
        }
        sourceAppInfo.setAppId(appId);
        sourceAppInfo.setIamApToken(iamApToken);
        return sourceAppInfo;
    }
}

