/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor.modular;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.MergeAppUtils;
import com.digiwin.app.merge.processor.FileProcessor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AppPropsProcessor {
    private static final Logger log = LogManager.getLogger(AppPropsProcessor.class);
    public static final String FILE_NAME = "application.properties";
    static final String KEY_LCDP_BM_ROLE = "lcdp.bm.role";
    static final String VALUE_LCDP_BM_ROLE = "mix";

    private AppPropsProcessor() {
    }

    public static String getApplicationFile(String workspace, String sourceAppRootDir) {
        return workspace + File.separator + sourceAppRootDir + File.separator + "develop" + File.separator + "conf" + File.separator + FILE_NAME;
    }

    public static String getTargetApplicationFile(String workspace) {
        return FileProcessor.getTargetApplicationConfDir(workspace) + File.separator + FILE_NAME;
    }

    public static void merge(String sourceFile, String targetFile) {
        try {
            Path targetFilePath = Paths.get(targetFile, new String[0]);
            if (Files.notExists(targetFilePath, new LinkOption[0])) {
                Files.createDirectories(targetFilePath.getParent(), new FileAttribute[0]);
                Files.createFile(targetFilePath, new FileAttribute[0]);
            }
            FileInputStream targetInputStream = new FileInputStream(targetFile);
            Properties targetProperties = new Properties();
            targetProperties.load(targetInputStream);
            targetInputStream.close();
            FileInputStream sourceInputStream = new FileInputStream(sourceFile);
            Properties sourceProperties = new Properties();
            sourceProperties.load(sourceInputStream);
            sourceInputStream.close();
            targetProperties.putAll((Map<?, ?>)sourceProperties);
            targetProperties.put(KEY_LCDP_BM_ROLE, VALUE_LCDP_BM_ROLE);
            ArrayList<Map.Entry<Object, Object>> sortedEntries = new ArrayList<Map.Entry<Object, Object>>(targetProperties.entrySet());
            sortedEntries.sort(Comparator.comparing(e -> (String)e.getKey()));
            BufferedWriter writer = Files.newBufferedWriter(targetFilePath, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            writer.write("# Merged application properties.");
            writer.newLine();
            for (Map.Entry entry : sortedEntries) {
                writer.write(entry.getKey() + "=" + entry.getValue());
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception e2) {
            log.error("\u5408\u4f75 application.properties \u6587\u4ef6\u5931\u6557\uff01", (Throwable)e2);
        }
    }

    public static void finishedMerge(MergeAppContext context) {
        String moduleAppRelationFile = FileProcessor.getModuleAppRelationFile(context.getWorkspace());
        StringBuilder contentToAppend = new StringBuilder();
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(moduleAppRelationFile, new String[0]), StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                contentToAppend.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            log.error(MergeAppUtils.indentMessage(context, "\u8b80\u53d6\u6a21\u7d44\u8207\u61c9\u7528\u6620\u5c04\u95dc\u4fc2\u4fe1\u606f\u5931\u6557\uff01"), (Throwable)e);
            return;
        }
        Path targetPath = Paths.get(AppPropsProcessor.getTargetApplicationFile(context.getWorkspace()), new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(targetPath, StandardCharsets.UTF_8, StandardOpenOption.APPEND);){
            writer.write(contentToAppend.toString());
        }
        catch (IOException e) {
            log.error(MergeAppUtils.indentMessage(context, "\u8ffd\u52a0\u6a21\u7d44\u8207\u61c9\u7528\u6620\u5c04\u95dc\u4fc2\u4fe1\u606f\u5931\u6557\uff01"), (Throwable)e);
        }
    }
}

