/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor.modular;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.MergeAppUtils;
import com.digiwin.app.merge.pojo.SourceAppInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DataPermissionProcessor {
    private static final Logger log = LogManager.getLogger(DataPermissionProcessor.class);
    static final String FILE_NAME_SCHEMAS = "data-permission-schemas.json";
    static final String FILE_NAME_VALUES = "data-permission-values.json";

    private DataPermissionProcessor() {
    }

    public static String getDataPermissionFileLocation(MergeAppContext context, String sourceAppRootDir, String fileName) {
        return context.getWorkspace() + File.separator + sourceAppRootDir + File.separator + "develop" + File.separator + "conf" + File.separator + fileName;
    }

    public static void merge(MergeAppContext context) {
        Map<String, SourceAppInfo> sourceApps = context.getAppInfoMap();
        String targetAppRootDir = context.getTargetAppFolderName();
        log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u6578\u64da\u6b0a\u9650\u5143\u6578\u64da\u6587\u4ef6", String.format("%s/%s", FILE_NAME_SCHEMAS, FILE_NAME_VALUES)));
        log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u61c9\u7528", context.getTargetAppInfo().getUniqueId()));
        String[] files = new String[]{FILE_NAME_SCHEMAS, FILE_NAME_VALUES};
        try {
            for (String file : files) {
                String sourceAppDataPermissionFileLocation = DataPermissionProcessor.getDataPermissionFileLocation(context, targetAppRootDir, file);
                Path sourceAppDataPermissionFilePath = Paths.get(sourceAppDataPermissionFileLocation, new String[0]);
                boolean sourceAppDataPermissionFileExists = Files.exists(sourceAppDataPermissionFilePath, new LinkOption[0]);
                log.info(MergeAppUtils.indentMessage(context, sourceAppDataPermissionFileExists ? "\u8907\u88fd\u6587\u4ef6: {}" : "\u4e0d\u8907\u88fd\u4e0d\u5b58\u5728\u7684\u6587\u4ef6: {}"), (Object)file);
                String targetFile = DataPermissionProcessor.getDataPermissionFileLocation(context, new File(context.getMergedAppPath()).getName(), file);
                Path targetFilePath = Paths.get(targetFile, new String[0]);
                if (!sourceAppDataPermissionFileExists) continue;
                if (Files.notExists(targetFilePath, new LinkOption[0])) {
                    Files.createDirectories(targetFilePath.getParent(), new FileAttribute[0]);
                }
                Files.copy(sourceAppDataPermissionFilePath, targetFilePath, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            log.error(MergeAppUtils.indentMessage(context, "\u6578\u64da\u6b0a\u9650\u914d\u7f6e\u8907\u88fd\u5931\u6557\uff01"), (Throwable)e);
        }
        for (SourceAppInfo sourceApp : sourceApps.values()) {
            String rootDir = sourceApp.getRootDir();
            if (targetAppRootDir.equals(rootDir)) continue;
            log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u61c9\u7528", sourceApp.getUniqueId()));
            for (String file : files) {
                String sourceAppDataPermissionFileLocation = DataPermissionProcessor.getDataPermissionFileLocation(context, sourceApp.getRootDir(), file);
                Path sourceAppDataPermissionFilePath = Paths.get(sourceAppDataPermissionFileLocation, new String[0]);
                boolean sourceAppDataPermissionFileExists = Files.exists(sourceAppDataPermissionFilePath, new LinkOption[0]);
                log.info(MergeAppUtils.indentMessage(context, sourceAppDataPermissionFileExists ? "\u8acb\u4eba\u5de5\u8655\u7406\u5408\u4f75, \u6587\u4ef6: {}" : "\u4e0d\u5b58\u5728\u7684\u6587\u4ef6: {}"), (Object)file);
            }
        }
        log.info(MergeAppUtils.indentMessage(2, "\u5408\u4f75\u5b8c\u6210\uff01"));
    }
}

