/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor.modular;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.MergeAppUtils;
import com.digiwin.app.merge.pojo.SourceAppInfo;
import com.digiwin.app.merge.processor.FileProcessor;
import com.digiwin.app.merge.processor.pojo.SourceAppElement;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class Log4j2Processor {
    private static final Logger log = LogManager.getLogger(Log4j2Processor.class);
    static final String FILE_NAME = "log4j2.xml";
    static final String ELEMENT_NAME_LOGGERS = "Loggers";
    static final String ELEMENT_NAME_LOGGER = "logger";

    private Log4j2Processor() {
    }

    public static String getLog4j2File(String workspace, String sourceAppRootDir) {
        return workspace + File.separator + sourceAppRootDir + File.separator + "develop" + File.separator + "conf" + File.separator + FILE_NAME;
    }

    public static String getTargetLog4j2File(String workspace) {
        return FileProcessor.getTargetApplicationConfDir(workspace) + File.separator + FILE_NAME;
    }

    public static SourceAppElement readLoggers(MergeAppContext context, SourceAppInfo sourceAppInfo, String sourceFile) {
        Path sourceFilePath = Paths.get(sourceFile, new String[0]);
        if (Files.notExists(sourceFilePath, new LinkOption[0])) {
            log.warn(MergeAppUtils.indentMessage(context, "\u6587\u4ef6{}\u4e0d\u5b58\u5728\uff0c\u8df3\u904e\u3002"), (Object)sourceFile);
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(sourceFilePath.toFile());
            Element rootElement = document.getDocumentElement();
            NodeList loggersNodes = rootElement.getElementsByTagName(ELEMENT_NAME_LOGGERS);
            if (loggersNodes.getLength() > 0) {
                return new SourceAppElement(sourceAppInfo, (Element)loggersNodes.item(0));
            }
        }
        catch (Exception e) {
            log.error("\u8b80\u53d6\u6587\u4ef6\u6642\u51fa\u932f\uff01", (Throwable)e);
        }
        return null;
    }

    public static void merge(MergeAppContext context, String sourceFile, String targetFile, List<SourceAppElement> loggers) {
        try {
            Path sourceFilePath = Paths.get(sourceFile, new String[0]);
            if (Files.notExists(sourceFilePath, new LinkOption[0])) {
                log.warn(MergeAppUtils.indentMessage(context, "\u6587\u4ef6{}\u4e0d\u5b58\u5728\uff0c\u8df3\u904e\u3002"), (Object)sourceFile);
                return;
            }
            Path targetFilePath = Paths.get(targetFile, new String[0]);
            log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u61c9\u7528", context.getTargetAppInfo().getUniqueId()));
            log.info(MergeAppUtils.indentMessage(context, "\u8907\u88fd\u6587\u4ef6\u5230: " + targetFilePath.toFile().getAbsolutePath()));
            if (Files.notExists(targetFilePath, new LinkOption[0])) {
                Files.createDirectories(targetFilePath.getParent(), new FileAttribute[0]);
                Files.copy(sourceFilePath, targetFilePath, new CopyOption[0]);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(targetFilePath.toFile());
            Element rootElement = document.getDocumentElement();
            NodeList loggersNodes = rootElement.getElementsByTagName(ELEMENT_NAME_LOGGERS);
            Element targetLoggers = (Element)loggersNodes.item(0);
            Map<String, Node> targetLoggerNodeMap = Log4j2Processor.getLoggerNodeMap(targetLoggers);
            for (SourceAppElement sourceAppElement : loggers) {
                log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u61c9\u7528", sourceAppElement.getSourceAppInfo().getUniqueId()));
                Map<String, Node> sourceLoggerNodeMap = Log4j2Processor.getLoggerNodeMap(sourceAppElement.getElement());
                for (Map.Entry<String, Node> entry : sourceLoggerNodeMap.entrySet()) {
                    String key = entry.getKey();
                    if (targetLoggerNodeMap.containsKey(key)) continue;
                    log.info(MergeAppUtils.indentMessage(context, "logger(name={})\uff0c\u8ffd\u52a0\u5230\u76ee\u6a19\u6587\u4ef6\u5167\u3002"), (Object)key);
                    targetLoggers.appendChild(targetLoggers.getOwnerDocument().importNode(entry.getValue(), true));
                    targetLoggerNodeMap.put(key, entry.getValue());
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(targetFilePath.toFile());
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            log.error(MergeAppUtils.indentMessage(2, "\u5408\u4f75\u65e5\u8a8c\u8a2d\u5b9a\u6587\u4ef6\u51fa\u932f\uff1a"), (Throwable)e);
        }
    }

    private static Map<String, Node> getLoggerNodeMap(Element element) {
        HashMap<String, Node> nodeMap = new HashMap<String, Node>();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1 || !ELEMENT_NAME_LOGGER.equalsIgnoreCase(nodeName = node.getNodeName())) continue;
            String key = ((Element)node).getAttribute("name");
            nodeMap.put(key, node);
        }
        return nodeMap;
    }
}

