/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor.modular;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.MergeAppUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModuleProcessor {
    private static final Logger log = LogManager.getLogger(ModuleProcessor.class);
    static final String MVN_TARGET = "target";

    private ModuleProcessor() {
    }

    public static String getModuleDir(String workspace, String sourceAppRootDir) {
        return workspace + File.separator + sourceAppRootDir + File.separator + "develop" + File.separator + "module";
    }

    public static String getPackagedModuleDir(String workspace, String sourceAppRootDir, String moduleName) {
        return workspace + File.separator + sourceAppRootDir + File.separator + "develop" + File.separator + "module" + File.separator + moduleName + File.separator + MVN_TARGET + File.separator + moduleName;
    }

    public static String getTargetModuleDir(String workspace) {
        return workspace + File.separator + "dap-merged-app" + File.separator + "application" + File.separator + "module";
    }

    public static List<Path> getModuleTargetPaths(MergeAppContext context, String moduleDir) {
        ArrayList<String> invalidModuleNames = new ArrayList<String>();
        context.setInvalidModuleNames(invalidModuleNames);
        ArrayList<Path> moduleTargetCompilePaths = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(moduleDir, new String[0]));){
            for (Path entry : stream) {
                if (!Files.isDirectory(entry, new LinkOption[0])) continue;
                String moduleName = entry.getFileName().toString();
                log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u6a21\u7d44", moduleName));
                Path targetFolderPath = Files.list(entry).filter(subPath -> Files.isDirectory(subPath, new LinkOption[0]) && MVN_TARGET.equals(subPath.getFileName().toString())).findFirst().orElse(null);
                if (targetFolderPath == null) {
                    invalidModuleNames.add(moduleName);
                    log.error(MergeAppUtils.indentMessage(3, "\u8a72\u6a21\u7d44\u6c92\u6709\u7de8\u8b6f\u5f8c\u7684 target \u6587\u4ef6\u593e! \u8def\u5f91: " + moduleName));
                    continue;
                }
                Path compiledResultFolderPath = Files.list(targetFolderPath).filter(subPath -> Files.isDirectory(subPath, new LinkOption[0]) && moduleName.equals(subPath.getFileName().toString())).findFirst().orElse(null);
                if (compiledResultFolderPath == null) {
                    invalidModuleNames.add(moduleName);
                    log.error(MergeAppUtils.indentMessage(3, "\u8a72\u6a21\u7d44\u6c92\u6709\u7de8\u8b6f\u5f8c\u7684 target \u6587\u4ef6\u593e\u4e0b, \u6c92\u6709\u540c\u6a21\u7d44\u540d\u7684\u6587\u4ef6\u593e, \u8def\u5f91: " + targetFolderPath.toFile().getAbsolutePath()));
                    continue;
                }
                moduleTargetCompilePaths.add(compiledResultFolderPath);
            }
        }
        catch (IOException e) {
            log.error("\u8b80\u53d6\u6a21\u7d44\u6e05\u55ae\u51fa\u932f: " + e.getMessage());
        }
        return moduleTargetCompilePaths;
    }

    public static List<String> getModuleNames(String moduleDir) {
        ArrayList<String> moduleNames = new ArrayList<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(moduleDir, new String[0]));){
            for (Path entry : stream) {
                if (!Files.isDirectory(entry, new LinkOption[0]) || !ModuleProcessor.isStandardModuleName(entry)) continue;
                String subdirectoryName = entry.getFileName().toString();
                moduleNames.add(subdirectoryName);
            }
        }
        catch (IOException e) {
            log.error("\u8b80\u53d6\u6a21\u7d44\u6e05\u55ae\u51fa\u932f: " + e.getMessage());
        }
        return moduleNames;
    }

    private static boolean isStandardModuleName(Path path) {
        try {
            List subDirs = Files.list(path).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
            if (subDirs.size() == 3) {
                long targetCount = subDirs.stream().filter(p -> MVN_TARGET.equals(p.getFileName().toString())).count();
                return targetCount == 1L;
            }
        }
        catch (IOException e) {
            log.error("\u8b80\u53d6\u6a21\u7d44\u6e05\u55ae\u51fa\u932f: " + e.getMessage());
        }
        log.warn("{}\u4e0d\u662f\u6807\u51c6\u6a21\u7ec4\uff0c\u4e0d\u5904\u7406\uff01", (Object)path.getFileName());
        return false;
    }

    public static void moduleCopier(String sourceDir, String targetDir) {
        block14: {
            Path sourceDirectory = Paths.get(sourceDir, new String[0]);
            Path targetDirectory = Paths.get(targetDir, new String[0]);
            try {
                Files.createDirectories(targetDirectory, new FileAttribute[0]);
                if (!ModuleProcessor.isStandardModule(sourceDirectory)) break block14;
                try (Stream<Path> paths = Files.walk(sourceDirectory, new FileVisitOption[0]);){
                    paths.forEach(path -> {
                        try {
                            Path relativePath = sourceDirectory.relativize((Path)path);
                            Path targetPath = targetDirectory.resolve(relativePath);
                            Files.copy(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            log.error("\u5408\u4f75\u6a21\u7d44\u4fe1\u606f\u6642\u51fa\u932f\uff1a", (Throwable)e);
                        }
                    });
                }
            }
            catch (IOException e) {
                log.error("\u5408\u4f75\u6a21\u7d44\u4fe1\u606f\u6642\u51fa\u932f\uff1a" + e.getMessage());
            }
        }
    }

    private static boolean isStandardModule(Path path) {
        Path grandparentDirectory;
        String currentDirectoryName = path.getFileName().toString();
        Path parentDirectory = path.getParent();
        if (Objects.nonNull(parentDirectory) && Objects.nonNull(grandparentDirectory = parentDirectory.getParent())) {
            String grandparentDirectoryName = grandparentDirectory.getFileName().toString();
            return currentDirectoryName.equals(grandparentDirectoryName);
        }
        log.warn("{}\u4e0d\u662f\u6807\u51c6\u6a21\u7ec4\uff0c\u4e0d\u5904\u7406\uff01", (Object)path.getFileName());
        return false;
    }
}

