/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor.modular;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.MergeAppUtils;
import com.digiwin.app.merge.processor.FileProcessor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServiceRetryProcessor {
    private static final Logger log = LogManager.getLogger(ServiceRetryProcessor.class);
    static final String FILE_NAME = "service-retry-config.json";
    static final String NODE_APP_ID = "appId";
    static final String NODE_PATHS = "paths";
    static final Gson GSON = new Gson();

    private ServiceRetryProcessor() {
    }

    public static String getServiceRetryConfigFile(String workspace, String sourceAppRootDir) {
        return workspace + File.separator + sourceAppRootDir + File.separator + "develop" + File.separator + "conf" + File.separator + FILE_NAME;
    }

    public static String getTargetServiceRetryConfigFile(String workspace) {
        return FileProcessor.getTargetApplicationConfDir(workspace) + File.separator + FILE_NAME;
    }

    public static void merge(MergeAppContext context, String sourceFile, String targetFile) {
        try {
            String appId;
            Path sourceFilePath = Paths.get(sourceFile, new String[0]);
            if (Files.notExists(sourceFilePath, new LinkOption[0])) {
                log.warn(MergeAppUtils.indentMessage(context, "\u6587\u4ef6{}\u4e0d\u5b58\u5728\uff0c\u8df3\u904e\u3002"), (Object)sourceFile);
                return;
            }
            Path targetFilePath = Paths.get(targetFile, new String[0]);
            if (Files.notExists(targetFilePath, new LinkOption[0])) {
                log.info(MergeAppUtils.indentMessage(context, "\u8907\u88fd\u6587\u4ef6\u5230: " + targetFilePath));
                Files.createDirectories(targetFilePath.getParent(), new FileAttribute[0]);
                Files.copy(sourceFilePath, targetFilePath, new CopyOption[0]);
                return;
            }
            Map<String, JsonElement> sourceMap = ServiceRetryProcessor.readAppRetryConfigMap(sourceFile);
            HashMap<String, List> targetMap = new HashMap<String, List>();
            JsonElement jsonElement = GSON.fromJson((Reader)new FileReader(targetFile), JsonElement.class);
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (JsonElement jsonElement2 : jsonArray) {
                appId = jsonElement2.getAsJsonObject().get(NODE_APP_ID).getAsString();
                JsonArray paths = jsonElement2.getAsJsonObject().get(NODE_PATHS).getAsJsonArray();
                Type typeToken = new TypeToken<List<JsonObject>>(){}.getType();
                List list = (List)GSON.fromJson((JsonElement)paths, typeToken);
                targetMap.put(appId, list);
            }
            for (Map.Entry entry : sourceMap.entrySet()) {
                appId = (String)entry.getKey();
                JsonElement element = (JsonElement)entry.getValue();
                if (!targetMap.containsKey(appId)) {
                    log.info(MergeAppUtils.indentMessage(context, "\u91cd\u8a66\u914d\u7f6e (appId={})\uff0c\u8ffd\u52a0\u5230\u76ee\u6a19\u6587\u4ef6\u5167\u3002"), (Object)appId);
                    jsonArray.add(element);
                    continue;
                }
                log.warn(MergeAppUtils.indentMessage(context, "\u91cd\u8a66\u914d\u7f6e (appId={}) \u5df2\u7d93\u5b58\u5728\uff0c\u4e0d\u5408\u4f75\u6b64\u90e8\u5206\u7684\u5167\u5bb9!"), (Object)appId);
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Files.write(targetFilePath, gson.toJson(jsonArray).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            log.error(MergeAppUtils.indentMessage(context, "\u5408\u4f75\u670d\u52d9\u91cd\u8a66\u914d\u7f6e\u6642\u51fa\u932f\uff1a"), (Throwable)e);
        }
    }

    private static Map<String, JsonElement> readAppRetryConfigMap(String sourceFile) {
        HashMap<String, JsonElement> map = new HashMap<String, JsonElement>();
        try {
            JsonElement jsonElement = GSON.fromJson((Reader)new FileReader(sourceFile), JsonElement.class);
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (JsonElement element : jsonArray) {
                String appId = element.getAsJsonObject().get(NODE_APP_ID).getAsString();
                map.put(appId, element);
            }
        }
        catch (Exception e) {
            log.error("\u8b80\u53d6\u670d\u52d9\u91cd\u8a66\u914d\u7f6e\u4fe1\u606f\u6642\u51fa\u932f\uff1a", (Throwable)e);
        }
        return map;
    }
}

