/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor.modular;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.MergeAppUtils;
import com.digiwin.app.merge.processor.FileProcessor;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SpringAppProcessor {
    private static final Logger log = LogManager.getLogger(SpringAppProcessor.class);
    static final String FILE_NAME = "spring-application.xml";
    static final String NODE_BEAN = "bean";
    static final String NODE_COMPONENT_SCAN = "context:component-scan";
    static final String NODE_ATTRIBUTE_ID = "id";
    static final String NODE_ATTRIBUTE_CLASS = "class";
    static final String NODE_ATTRIBUTE_BASE_PACKAGE = "base-package";

    private SpringAppProcessor() {
    }

    public static String getSpringApplicationFile(String workspace, String sourceAppRootDir) {
        return workspace + File.separator + sourceAppRootDir + File.separator + "develop" + File.separator + "conf" + File.separator + FILE_NAME;
    }

    public static String getTargetSpringApplicationFile(String workspace) {
        return FileProcessor.getTargetApplicationConfDir(workspace) + File.separator + FILE_NAME;
    }

    public static void readBeanAndComponentScan(MergeAppContext context, String sourceFile, List<Element> beanList, List<Element> componentScanList) {
        Path sourceFilePath = Paths.get(sourceFile, new String[0]);
        if (Files.notExists(sourceFilePath, new LinkOption[0])) {
            log.warn(MergeAppUtils.indentMessage(context.getLogIndent(), "\u6587\u4ef6{}\u4e0d\u5b58\u5728\uff0c\u8df3\u904e\u3002"), (Object)sourceFile);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(sourceFilePath.toFile());
            Element rootElement = doc.getDocumentElement();
            NodeList beans = rootElement.getElementsByTagName(NODE_BEAN);
            for (int i = 0; i < beans.getLength(); ++i) {
                Node bean = beans.item(i);
                if (bean.getNodeType() != 1) continue;
                Element beanElement = (Element)bean;
                beanList.add(beanElement);
            }
            NodeList componentScans = rootElement.getElementsByTagName(NODE_COMPONENT_SCAN);
            for (int i = 0; i < componentScans.getLength(); ++i) {
                Node componentScan = componentScans.item(i);
                if (componentScan.getNodeType() != 1) continue;
                Element componentScanElement = (Element)componentScan;
                componentScanList.add(componentScanElement);
            }
        }
        catch (Exception e) {
            log.error("\u8b80\u53d6spring-application.xml\u6587\u4ef6\u6642\u51fa\u932f\uff1a", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void merge(MergeAppContext context, String sourceFile, String targetFile, List<Element> beanList, List<Element> componentScanList) {
        try {
            void var16_20;
            Path sourceFilePath = Paths.get(sourceFile, new String[0]);
            if (Files.notExists(sourceFilePath, new LinkOption[0])) {
                log.warn(MergeAppUtils.indentMessage(2, "\u4f86\u6e90\u6587\u4ef6{}\u4e0d\u5b58\u5728\uff0c\u8df3\u904e\u3002"), (Object)sourceFile);
                return;
            }
            Path targetFilePath = Paths.get(targetFile, new String[0]);
            if (Files.notExists(targetFilePath, new LinkOption[0])) {
                log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u61c9\u7528", context.getTargetAppInfo().getUniqueId()));
                log.info(MergeAppUtils.indentMessage(context, "\u8907\u88fd\u6587\u4ef6\u5230: " + targetFilePath));
                Files.createDirectories(targetFilePath.getParent(), new FileAttribute[0]);
                Files.copy(sourceFilePath, targetFilePath, new CopyOption[0]);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(targetFilePath.toFile());
            Element rootElement = document.getDocumentElement();
            NodeList beans = rootElement.getElementsByTagName(NODE_BEAN);
            ArrayList<Element> targetBeanList = new ArrayList<Element>();
            for (int i2 = 0; i2 < beans.getLength(); ++i2) {
                Node bean = beans.item(i2);
                if (bean.getNodeType() != 1) continue;
                Element beanElement = (Element)bean;
                targetBeanList.add(beanElement);
            }
            Map<String, Node> targetBeanMap = SpringAppProcessor.getBeanNodes(targetBeanList);
            Map<String, Node> sourceBeanMap = SpringAppProcessor.getBeanNodes(beanList);
            for (Map.Entry entry : sourceBeanMap.entrySet()) {
                String key = (String)entry.getKey();
                if (targetBeanMap.containsKey(key)) continue;
                log.info(MergeAppUtils.indentMessage(context, "bean(id={})\uff0c\u8ffd\u52a0\u5230\u76ee\u6a19\u6587\u4ef6\u5167\u3002"), (Object)key);
                rootElement.appendChild(rootElement.getOwnerDocument().importNode((Node)entry.getValue(), true));
                targetBeanMap.put(key, (Node)entry.getValue());
            }
            NodeList componentScans = rootElement.getElementsByTagName(NODE_COMPONENT_SCAN);
            boolean bl = false;
            while (var16_20 < componentScans.getLength()) {
                Node componentScan = componentScans.item((int)var16_20);
                if (componentScan.getNodeType() == 1) {
                    Element componentScanElement = (Element)componentScan;
                    componentScanList.add(componentScanElement);
                    rootElement.removeChild(componentScan);
                }
                ++var16_20;
            }
            boolean bl2 = true;
            HashSet<String> basePackages = new HashSet<String>();
            for (Element componentScan : componentScanList) {
                void var16_22;
                Set<String> basePackageList = SpringAppProcessor.getBasePackages(componentScan);
                basePackages.addAll(basePackageList);
                log.info(MergeAppUtils.indentMessage(context, String.format("\u6383\u63cf\u5305\u8def\u5f91 %02d: %s", (int)(++var16_22), basePackageList)));
            }
            Element newComponentScan = document.createElement(NODE_COMPONENT_SCAN);
            newComponentScan.setAttribute(NODE_ATTRIBUTE_BASE_PACKAGE, String.join((CharSequence)",", basePackages));
            rootElement.appendChild(newComponentScan);
            log.info(MergeAppUtils.indentMessage(context, String.format("\u5408\u4f75\u5f8c\u7684\u6383\u63cf\u5305\u8def\u5f91: [%s]", String.join((CharSequence)",", basePackages))));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(targetFilePath.toFile());
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            log.error("\u5408\u4f75spring-application.xml\u6642\uff0c\u51fa\u932f\uff1a", (Throwable)e);
        }
    }

    private static Map<String, Node> getBeanNodes(List<Element> beanList) {
        HashMap<String, Node> nodeMap = new HashMap<String, Node>();
        for (Element bean : beanList) {
            String beanId = bean.getAttribute(NODE_ATTRIBUTE_ID);
            nodeMap.put(beanId, bean);
        }
        return nodeMap;
    }

    private static Set<String> getBasePackages(Element componentScan) {
        HashSet<String> basePackageList = new HashSet<String>();
        String basePackages = componentScan.getAttribute(NODE_ATTRIBUTE_BASE_PACKAGE);
        if (!basePackages.isEmpty()) {
            String[] basePackagesArray = basePackages.split(",");
            basePackageList.addAll(Arrays.asList(basePackagesArray));
        }
        return basePackageList;
    }
}

