/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor.simplified;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.MergeAppUtils;
import com.digiwin.app.merge.pojo.AppModuleNameInfo;
import com.digiwin.app.merge.pojo.SourceAppInfo;
import com.digiwin.app.merge.pojo.SourceSimplifiedAppInfo;
import com.digiwin.app.merge.processor.FileProcessor;
import com.digiwin.app.merge.processor.PropertiesProcessor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GroupProcessor {
    private static final Logger log = LogManager.getLogger(GroupProcessor.class);
    static final String FILE_NAME = "dap.info";
    static final String KEY_GROUP_NAME = "group.name";
    static final String DEFAULT_FILE_PATH = "develop/src/main/resources/META-INF";
    static final String MODULE_PATH = "develop/module";
    static final String MODULE_FILE_PATH = "resources/META-INF";

    private GroupProcessor() {
    }

    public static void processGroupName(MergeAppContext context) {
        log.info(MergeAppUtils.createStepTitleMessage(context, "\u6aa2\u6e2c", "\u7fa4\u7d44\u540d\u7a31"));
        HashMap<String, List<AppModuleNameInfo>> moduleNameInfoMap = new HashMap<String, List<AppModuleNameInfo>>();
        log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u61c9\u7528", context.getTargetAppInfo().getUniqueId()));
        List<AppModuleNameInfo> groupInfoList = GroupProcessor.createGroupInfoList(context, (SourceSimplifiedAppInfo)context.getTargetAppInfo());
        moduleNameInfoMap.put(context.getTargetAppInfo().getRootDir(), groupInfoList);
        context.getModuleInfoList().addAll(groupInfoList);
        log.info(MergeAppUtils.indentMessage(2, "\u7fa4\u7d44\u6e05\u55ae: " + groupInfoList.stream().map(g -> g.getOriginalModuleName()).collect(Collectors.toList())));
        for (SourceAppInfo appInfo : context.getAppInfoMap().values()) {
            if (appInfo.isTarget()) continue;
            log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u61c9\u7528", appInfo.getUniqueId()));
            groupInfoList = GroupProcessor.createGroupInfoList(context, (SourceSimplifiedAppInfo)appInfo);
            log.info(MergeAppUtils.indentMessage(2, "\u7fa4\u7d44\u6e05\u55ae: " + groupInfoList.stream().map(g -> g.getOriginalModuleName()).collect(Collectors.toList())));
            context.getModuleInfoList().addAll(groupInfoList);
            moduleNameInfoMap.put(appInfo.getRootDir(), groupInfoList);
        }
        FileProcessor.recordModuleAppMapping(context, moduleNameInfoMap);
        log.info(MergeAppUtils.indentMessage(1, "**\u6aa2\u6e2c\u5b8c\u6210**"));
    }

    private static List<AppModuleNameInfo> createGroupInfoList(MergeAppContext context, SourceSimplifiedAppInfo appInfo) {
        Set currentGroupNames = context.getModuleInfoList().stream().map(g -> g.getRenamedModuleName() == null ? g.getOriginalModuleName() : g.getRenamedModuleName()).collect(Collectors.toSet());
        ArrayList<AppModuleNameInfo> moduleInfoList = new ArrayList<AppModuleNameInfo>();
        ArrayList<Path> dapInfoFilePathList = new ArrayList<Path>();
        String backendDir = appInfo.getBackendPath().toFile().getAbsolutePath();
        dapInfoFilePathList.add(Paths.get(backendDir, DEFAULT_FILE_PATH, FILE_NAME));
        Path modulePath = Paths.get(backendDir, MODULE_PATH);
        if (Files.exists(modulePath, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(modulePath);){
                for (Path entry : stream) {
                    if (!Files.isDirectory(entry, new LinkOption[0])) continue;
                    dapInfoFilePathList.add(Paths.get(entry.toString(), MODULE_FILE_PATH, FILE_NAME));
                }
            }
            catch (IOException e) {
                log.error("\u5c0b\u627e\u7fa4\u7d44\u4fe1\u606f\u6587\u4ef6\u51fa\u932f: " + e.getMessage());
            }
        }
        for (Path dapInfoPath : dapInfoFilePathList) {
            String groupName = PropertiesProcessor.getProperty(dapInfoPath, KEY_GROUP_NAME);
            AppModuleNameInfo groupInfo = new AppModuleNameInfo();
            groupInfo.setSourceAppInfo(appInfo);
            groupInfo.setRootDir(appInfo.getRootDir());
            groupInfo.setAppId(appInfo.getAppId());
            groupInfo.setIamApToken(appInfo.getIamApToken());
            groupInfo.setOriginalModuleName(groupName);
            groupInfo.setDapInfoPath(dapInfoPath);
            if (currentGroupNames.contains(groupName)) {
                String newGroupName = groupName + "_" + appInfo.getAppId();
                log.warn(MergeAppUtils.indentMessage(2, String.format("\u540d\u7a31: %s \u5df2\u5b58\u5728, \u5408\u4f75\u6642\u5c07\u91cd\u65b0\u547d\u540d\u70ba: %s, \u6587\u4ef6\u8def\u5f91: %s", groupName, newGroupName, dapInfoPath.toFile().getAbsolutePath())));
                groupInfo.setRenamedModuleName(newGroupName);
                GroupProcessor.renameGroupName(dapInfoPath, newGroupName);
            }
            moduleInfoList.add(groupInfo);
        }
        return moduleInfoList;
    }

    private static void renameGroupName(Path filePath, String newGroupName) {
        try {
            FileInputStream inputStream = new FileInputStream(filePath.toFile());
            Properties prop = new Properties();
            prop.load(inputStream);
            inputStream.close();
            prop.setProperty(KEY_GROUP_NAME, newGroupName);
            FileOutputStream fos = new FileOutputStream(filePath.toFile());
            prop.store(fos, null);
            fos.close();
        }
        catch (Exception e) {
            log.error("9,\u91cd\u547d\u540d\u7fa4\u7d44\u540d\u7a31\u51fa\u932f: " + e.getMessage());
        }
    }
}

