/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor.simplified;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.MergeAppUtils;
import com.digiwin.app.merge.pojo.SourceSimplifiedAppInfo;
import com.digiwin.app.merge.processor.FileProcessor;
import com.digiwin.app.merge.processor.modular.AppPropsProcessor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SimplifiedDAPAppPropsProcessor {
    private static final Logger log = LogManager.getLogger(SimplifiedDAPAppPropsProcessor.class);
    public static final String FILE_NAME = "application.properties";
    static final String KEY_LCDP_BM_ROLE = "lcdp.bm.role";
    static final String VALUE_LCDP_BM_ROLE = "mix";

    public static String getMergedApplicationProperties(MergeAppContext context) {
        String mergedAppPath = context.getMergedAppPath();
        Path applicationPropertiesPath = Paths.get(mergedAppPath, "conf", FILE_NAME);
        return applicationPropertiesPath.toFile().getAbsolutePath();
    }

    public static String getApplicationProperties(MergeAppContext context, SourceSimplifiedAppInfo sourceAppInfo) {
        Path applicationPropertiesPath = sourceAppInfo.getBackendPath().resolve("develop").resolve("conf").resolve(FILE_NAME);
        return applicationPropertiesPath.toFile().getAbsolutePath();
    }

    public static void merge(String sourceFile, String targetFile) {
        AppPropsProcessor.merge(sourceFile, targetFile);
    }

    public static void finishedMerge(MergeAppContext context) {
        String moduleAppRelationFile = FileProcessor.getGroupAppRelationFile(context.getWorkspace());
        StringBuilder contentToAppend = new StringBuilder();
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(moduleAppRelationFile, new String[0]), StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                contentToAppend.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            log.error(MergeAppUtils.indentMessage(context, "\u8b80\u53d6\u7fa4\u7d44\u8207\u61c9\u7528\u6620\u5c04\u95dc\u4fc2\u4fe1\u606f\u5931\u6557\uff01"), (Throwable)e);
            return;
        }
        Path targetPath = Paths.get(SimplifiedDAPAppPropsProcessor.getMergedApplicationProperties(context), new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(targetPath, StandardCharsets.UTF_8, StandardOpenOption.APPEND);){
            writer.write(contentToAppend.toString());
        }
        catch (IOException e) {
            log.error(MergeAppUtils.indentMessage(context, "\u8ffd\u52a0\u6a21\u7d44\u8207\u61c9\u7528\u6620\u5c04\u95dc\u4fc2\u4fe1\u606f\u5931\u6557"), (Throwable)e);
        }
    }
}

