/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor.simplified;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.MergeAppUtils;
import com.digiwin.app.merge.pojo.SourceAppInfo;
import com.digiwin.app.merge.pojo.SourceSimplifiedAppInfo;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SimplifiedDataPermissionProcessor {
    private static final Logger log = LogManager.getLogger(SimplifiedDataPermissionProcessor.class);
    static final String FILE_NAME_SCHEMAS = "data-permission-schemas-application.json";
    static final String FILE_NAME_VALUES = "data-permission-values-application.json";

    private SimplifiedDataPermissionProcessor() {
    }

    @Deprecated
    public static String getMergedDataPermissionSchemas(MergeAppContext context) {
        Path serviceRetryConfigPath = Paths.get(context.getMergedAppPath(), "conf", FILE_NAME_SCHEMAS);
        return serviceRetryConfigPath.toFile().getAbsolutePath();
    }

    @Deprecated
    public static String getMergedDataPermissionValues(MergeAppContext context) {
        Path serviceRetryConfigPath = Paths.get(context.getMergedAppPath(), "conf", FILE_NAME_VALUES);
        return serviceRetryConfigPath.toFile().getAbsolutePath();
    }

    @Deprecated
    public static String getDataPermissionSchemas(MergeAppContext context, SourceSimplifiedAppInfo sourceAppInfo) {
        Path springXmlPath = sourceAppInfo.getBackendPath().resolve("develop").resolve("conf").resolve(FILE_NAME_SCHEMAS);
        return springXmlPath.toFile().getAbsolutePath();
    }

    @Deprecated
    public static String getDataPermissionValues(MergeAppContext context, SourceSimplifiedAppInfo sourceAppInfo) {
        Path springXmlPath = sourceAppInfo.getBackendPath().resolve("develop").resolve("conf").resolve(FILE_NAME_VALUES);
        return springXmlPath.toFile().getAbsolutePath();
    }

    public static String getMergedDataPermissionFileLocation(MergeAppContext context, String fileName) {
        Path dataPermissionPath = Paths.get(context.getMergedAppPath(), "conf", fileName);
        return dataPermissionPath.toFile().getAbsolutePath();
    }

    public static String getDataPermissionFileLocation(MergeAppContext context, SourceSimplifiedAppInfo sourceAppInfo, String fileName) {
        Path springXmlPath = sourceAppInfo.getBackendPath().resolve("develop").resolve("conf").resolve(fileName);
        return springXmlPath.toFile().getAbsolutePath();
    }

    public static void merge(MergeAppContext context) {
        Map<String, SourceAppInfo> sourceApps = context.getAppInfoMap();
        log.info(MergeAppUtils.createSubStepTitleMessage(context, "\u6578\u64da\u6b0a\u9650\u5143\u6578\u64da\u6587\u4ef6", String.format("%s/%s", FILE_NAME_SCHEMAS, FILE_NAME_VALUES)));
        log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u61c9\u7528", context.getTargetAppInfo().getUniqueId()));
        String[] files = new String[]{FILE_NAME_SCHEMAS, FILE_NAME_VALUES};
        try {
            for (String file : files) {
                String sourceAppDataPermissionFileLocation = SimplifiedDataPermissionProcessor.getDataPermissionFileLocation(context, (SourceSimplifiedAppInfo)context.getTargetAppInfo(), file);
                Path sourceAppDataPermissionFilePath = Paths.get(sourceAppDataPermissionFileLocation, new String[0]);
                boolean sourceAppDataPermissionFileExists = Files.exists(sourceAppDataPermissionFilePath, new LinkOption[0]);
                log.info(MergeAppUtils.indentMessage(context, sourceAppDataPermissionFileExists ? "\u8907\u88fd\u6587\u4ef6: {}" : "\u4e0d\u8907\u88fd\u4e0d\u5b58\u5728\u7684\u6587\u4ef6: {}"), (Object)file);
                String targetFile = SimplifiedDataPermissionProcessor.getMergedDataPermissionFileLocation(context, file);
                Path targetFilePath = Paths.get(targetFile, new String[0]);
                if (!sourceAppDataPermissionFileExists) continue;
                if (Files.notExists(targetFilePath, new LinkOption[0])) {
                    Files.createDirectories(targetFilePath.getParent(), new FileAttribute[0]);
                }
                Files.copy(sourceAppDataPermissionFilePath, targetFilePath, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            log.error(MergeAppUtils.indentMessage(context, "\u6578\u64da\u6b0a\u9650\u914d\u7f6e\u8907\u88fd\u5931\u6557\uff01"), (Throwable)e);
        }
        for (SourceAppInfo sourceApp : sourceApps.values()) {
            if (sourceApp.isTarget()) continue;
            log.info(MergeAppUtils.createSubSubStepTitleMessage(context, "\u61c9\u7528", sourceApp.getUniqueId()));
            for (String file : files) {
                String sourceAppDataPermissionFileLocation = SimplifiedDataPermissionProcessor.getDataPermissionFileLocation(context, (SourceSimplifiedAppInfo)sourceApp, file);
                Path sourceAppDataPermissionFilePath = Paths.get(sourceAppDataPermissionFileLocation, new String[0]);
                boolean sourceAppDataPermissionFileExists = Files.exists(sourceAppDataPermissionFilePath, new LinkOption[0]);
                log.info(MergeAppUtils.indentMessage(context, sourceAppDataPermissionFileExists ? "\u8acb\u4eba\u5de5\u8655\u7406\u5408\u4f75, \u6587\u4ef6: {}" : "\u4e0d\u5b58\u5728\u7684\u6587\u4ef6: {}"), (Object)file);
            }
        }
        log.info(MergeAppUtils.indentMessage(2, "\u5408\u4f75\u5b8c\u6210\uff01"));
    }
}

