/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor.simplified;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.pojo.SourceAppInfo;
import com.digiwin.app.merge.pojo.SourceSimplifiedAppInfo;
import com.digiwin.app.merge.processor.modular.Log4j2Processor;
import com.digiwin.app.merge.processor.pojo.SourceAppElement;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SimplifiedLog4j2Processor {
    private static final Logger log = LogManager.getLogger(SimplifiedLog4j2Processor.class);
    static final String FILE_NAME = "log4j2.xml";
    static final String ELEMENT_NAME_LOGGERS = "Loggers";
    static final String ELEMENT_NAME_LOGGER = "logger";

    private SimplifiedLog4j2Processor() {
    }

    public static String getLog4j2File(MergeAppContext context, SourceSimplifiedAppInfo sourceAppInfo) {
        Path springXmlPath = sourceAppInfo.getBackendPath().resolve("develop").resolve("conf").resolve(FILE_NAME);
        return springXmlPath.toFile().getAbsolutePath();
    }

    public static String getMergedLog4j2File(MergeAppContext context) {
        Path log4j2XmlPath = Paths.get(context.getMergedAppPath(), "conf", FILE_NAME);
        return log4j2XmlPath.toFile().getAbsolutePath();
    }

    public static SourceAppElement readLoggers(MergeAppContext context, SourceAppInfo sourceAppInfo, String sourceFile) {
        return Log4j2Processor.readLoggers(context, sourceAppInfo, sourceFile);
    }

    public static void merge(MergeAppContext context, String sourceFile, String targetFile, List<SourceAppElement> loggers) {
        Log4j2Processor.merge(context, sourceFile, targetFile, loggers);
    }
}

