/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor.simplified;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.SimplifiedDAPUtils;
import com.digiwin.app.merge.pojo.SourceSimplifiedAppInfo;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SimplifiedPlatformProcessor {
    private static final Logger log = LogManager.getLogger(SimplifiedPlatformProcessor.class);

    private SimplifiedPlatformProcessor() {
    }

    public static String getPlatformDir(SourceSimplifiedAppInfo appInfo) {
        String compileOutputBackendDir = SimplifiedDAPUtils.getCompileOutputBackendPath(appInfo).toFile().getAbsolutePath();
        return compileOutputBackendDir + File.separator + File.separator + "platform";
    }

    public static String getMergedAppPlatformPath(MergeAppContext context) {
        return Paths.get(context.getMergedAppPath(), "platform").toFile().getAbsolutePath();
    }

    public static void copy(Path sourceDir, Path targetDir) {
        try {
            Files.createDirectories(targetDir, new FileAttribute[0]);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(sourceDir);){
                for (Path entry : stream) {
                    Path targetEntry = targetDir.resolve(sourceDir.relativize(entry));
                    if (Files.isDirectory(entry, new LinkOption[0])) {
                        SimplifiedPlatformProcessor.copy(entry, targetEntry);
                        continue;
                    }
                    Files.copy(entry, targetEntry, StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        catch (Exception e) {
            log.error("9,\u8907\u88fdplatform\u6587\u4ef6\u593e\u6642\u51fa\u932f: " + e.getMessage());
        }
    }
}

