/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor.simplified;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.enums.SimplifiedDAPConfigLayer;
import com.digiwin.app.merge.pojo.SourceSimplifiedAppInfo;
import com.digiwin.app.merge.processor.modular.ServiceRetryProcessor;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SimplifiedServiceRetryProcessor {
    private static final Logger log = LogManager.getLogger(SimplifiedServiceRetryProcessor.class);
    static final String FILE_FORMAT_SERVICE_RETRY_CONFIG = "service-retry-config-%s.json";

    private SimplifiedServiceRetryProcessor() {
    }

    public static String getServiceRetryConfigFile(MergeAppContext context, SourceSimplifiedAppInfo sourceAppInfo, SimplifiedDAPConfigLayer layer) {
        Path serviceRetryConfigPath = sourceAppInfo.getBackendPath().resolve("develop").resolve("conf").resolve(String.format(FILE_FORMAT_SERVICE_RETRY_CONFIG, layer.toString().toLowerCase()));
        return serviceRetryConfigPath.toFile().getAbsolutePath();
    }

    public static String getMergedServiceRetryConfigFile(MergeAppContext context, SimplifiedDAPConfigLayer layer) {
        Path serviceRetryConfigPath = Paths.get(context.getMergedAppPath(), "conf", String.format(FILE_FORMAT_SERVICE_RETRY_CONFIG, layer.toString().toLowerCase()));
        return serviceRetryConfigPath.toFile().getAbsolutePath();
    }

    public static void merge(MergeAppContext context, String sourceFile, String targetFile) {
        ServiceRetryProcessor.merge(context, sourceFile, targetFile);
    }
}

