/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor.simplified;

import com.digiwin.app.merge.MergeAppContext;
import com.digiwin.app.merge.pojo.SourceSimplifiedAppInfo;
import com.digiwin.app.merge.processor.modular.SpringAppProcessor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

public final class SimplifiedSpringAppProcessor {
    private static final Logger log = LogManager.getLogger(SimplifiedSpringAppProcessor.class);
    static final String FILE_NAME = "spring-application.xml";
    static final String NODE_BEAN = "bean";
    static final String NODE_COMPONENT_SCAN = "context:component-scan";
    static final String NODE_ATTRIBUTE_ID = "id";
    static final String NODE_ATTRIBUTE_CLASS = "class";
    static final String NODE_ATTRIBUTE_BASE_PACKAGE = "base-package";

    private SimplifiedSpringAppProcessor() {
    }

    public static String getSpringApplicationFile(MergeAppContext context, SourceSimplifiedAppInfo sourceAppInfo) {
        Path springXmlPath = sourceAppInfo.getBackendPath().resolve("develop").resolve("conf").resolve(FILE_NAME);
        return springXmlPath.toFile().getAbsolutePath();
    }

    public static String getMergedSpringApplicationFile(MergeAppContext context) {
        Path springXmlPath = Paths.get(context.getMergedAppPath(), "conf", FILE_NAME);
        return springXmlPath.toFile().getAbsolutePath();
    }

    public static void readBeanAndComponentScan(MergeAppContext context, String sourceFile, List<Element> beanList, List<Element> componentScanList) {
        SpringAppProcessor.readBeanAndComponentScan(context, sourceFile, beanList, componentScanList);
    }

    public static void merge(MergeAppContext context, String sourceFile, String targetFile, List<Element> beanList, List<Element> componentScanList) {
        SpringAppProcessor.merge(context, sourceFile, targetFile, beanList, componentScanList);
    }
}

