/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.cache;

import com.digiwin.gateway.cache.DWCache;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DWInMemoryCache
implements DWCache {
    private static final String CLEANER_THREAD_NAME = "DWInMemoryCache_cleaner";
    protected static final int DEFAULT_CLEAN_UP_PRE_SECOND = 60;
    protected int cleanUpPreSecond;
    private final ConcurrentHashMap<String, SoftReference<CacheSupport>> cache = new ConcurrentHashMap();

    public DWInMemoryCache() {
        this.cleanUpPreSecond = 60;
        this.startCleanerThread();
    }

    public DWInMemoryCache(int cleanUpPreSecond) {
        this.cleanUpPreSecond = cleanUpPreSecond > 0 ? cleanUpPreSecond : 60;
        this.startCleanerThread();
    }

    public Object get(String key) throws Exception {
        SoftReference cacheSupport = this.cache.getOrDefault(key, null);
        if (cacheSupport == null) {
            return null;
        }
        if (((CacheSupport)cacheSupport.get()).isExpired()) {
            return null;
        }
        return ((CacheSupport)cacheSupport.get()).getValue();
    }

    public boolean isPresent(String key) throws Exception {
        return this.cache.containsKey(key);
    }

    public void put(String key, Object value) throws Exception {
        this.put(key, value, -1);
    }

    public void put(String key, Object value, int aliveSecond) throws Exception {
        if (key == null) {
            throw new IllegalArgumentException("key can't be null");
        }
        long expiryTime = System.currentTimeMillis() + (long)(aliveSecond * 1000);
        if ((long)aliveSecond == -1L) {
            expiryTime = -1L;
        }
        this.cache.put(key, new SoftReference<CacheSupport>(new CacheSupport(value, expiryTime)));
    }

    public void remove(String key) throws Exception {
        this.cache.remove(key);
    }

    public int size() throws Exception {
        return this.cache.size();
    }

    public void clear() throws Exception {
        this.cache.clear();
    }

    public int getCleanUpPreSecond() {
        return this.cleanUpPreSecond;
    }

    private void startCleanerThread() {
        Thread cleanerThread = new Thread(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(this.cleanUpPreSecond * 1000);
                    for (Map.Entry<String, SoftReference<CacheSupport>> entry : this.cache.entrySet()) {
                        String key = entry.getKey();
                        SoftReference<CacheSupport> value = entry.getValue();
                        CacheSupport cacheSupport = value.get();
                        if (!cacheSupport.isExpired()) continue;
                        this.cache.remove(key);
                    }
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
        }, CLEANER_THREAD_NAME);
        cleanerThread.setDaemon(true);
        cleanerThread.start();
    }

    private class CacheSupport {
        private Object value;
        private long expiryTime;

        public CacheSupport(Object value, long expiryTime) {
            this.value = value;
            this.expiryTime = expiryTime;
        }

        boolean isExpired() {
            if (0L > this.expiryTime) {
                return false;
            }
            return System.currentTimeMillis() > this.expiryTime;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

