/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.configcenter.nacos.config.loader;

import com.digiwin.configcenter.DWConfigTypeEnum;
import com.digiwin.configcenter.nacos.DWConfigFile;
import com.digiwin.configcenter.nacos.config.loader.AbstractConfigLoader;
import com.digiwin.configcenter.nacos.config.loader.GroupConfigLoader;
import com.digiwin.configcenter.nacos.properties.DAPNacosConfigProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class ApplicationConfigLoader
extends AbstractConfigLoader {
    private static final Log logger = LogFactory.getLog(ApplicationConfigLoader.class);
    public static final Integer CONFIG_ORDER = GroupConfigLoader.CONFIG_ORDER - 1000;
    public static final String DAP_APPLICATION_REMOTE_CONFIG_PREFIX = "dap.application.remote.config.";

    @Override
    String getpropertySourceName(DWConfigFile configFile) {
        return "dap.application.remote.config.#@#" + configFile.getGroup() + "#@#" + configFile.getName();
    }

    @Override
    List<DWConfigFile> getConfigFile(ConfigurableEnvironment environment, DAPNacosConfigProperty dapNacosConfigProperty) {
        String nameSpace = environment.getProperty("appId");
        String group = environment.getProperty("SMALLVERSION");
        String applicationautorefreshStr = environment.getProperty("dap.configcenter.application.autorefresh", "true");
        Boolean applicationautorefresh = StringUtils.isNotBlank((CharSequence)applicationautorefreshStr) ? Boolean.valueOf(applicationautorefreshStr).booleanValue() : dapNacosConfigProperty.isAutoRefresh();
        String finalautorefreshStr = Boolean.toString(applicationautorefresh);
        String configTypeStr = environment.getProperty("dap.configcenter.file.type", "JSON");
        String configType = DWConfigTypeEnum.valueOfTypeName(configTypeStr).name();
        ArrayList<DWConfigFile> dwConfigFiles = new ArrayList<DWConfigFile>();
        String appimageName = environment.getProperty("APPIMAGENAME");
        String appId = environment.getProperty("appId");
        String defaultapplicationDataIds = appId + "_" + appimageName + "_env.json";
        String applicationDataIds = environment.getProperty("dap.configcenter.application.configs", defaultapplicationDataIds);
        for (String dataId : applicationDataIds.split(",")) {
            String resolvedDataId = environment.resolvePlaceholders(dataId);
            DWConfigFile dwConfigFile = new DWConfigFile(nameSpace, group, resolvedDataId, configType, finalautorefreshStr);
            dwConfigFiles.add(dwConfigFile);
        }
        return dwConfigFiles;
    }

    @Override
    public int getOrder() {
        return CONFIG_ORDER;
    }

    @Override
    public String getNameSpace(ConfigurableEnvironment environment) {
        return environment.getProperty("appId");
    }
}

