/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.configcenter.nacos.parse;

import com.alibaba.nacos.api.config.ConfigType;
import com.digiwin.configcenter.nacos.parse.NacosConfigParse;
import java.io.ByteArrayInputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultXmlConfigParse
implements NacosConfigParse {
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    @Override
    public Map<String, Object> parse(String configText) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(8);
        try {
            Document document = this.factory.newDocumentBuilder().parse(new ByteArrayInputStream(configText.getBytes("UTF-8")));
            Element root = document.getDocumentElement();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(8);
            this.recursionXmlToMap(map, root);
            this.mapToProperties("", properties, map);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    private void recursionXmlToMap(Map<String, Object> outMap, Element element) {
        NodeList nodeList = element.getChildNodes();
        String name = element.getNodeName();
        if (nodeList.getLength() == 1 && !nodeList.item(0).hasChildNodes()) {
            this.addData(outMap, name, element.getTextContent());
        } else {
            LinkedHashMap<String, Object> innerMap = new LinkedHashMap<String, Object>(1);
            int length = nodeList.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element tElement = (Element)node;
                this.recursionXmlToMap(innerMap, tElement);
            }
            this.addData(outMap, name, innerMap);
        }
    }

    private void addData(Map<String, Object> map, String key, Object data) {
        if (map.containsKey(key)) {
            if (map.get(key) instanceof List) {
                ((List)map.get(key)).add(data);
            } else {
                LinkedList<Object> list = new LinkedList<Object>();
                list.add(map.get(key));
                map.put(key, list);
            }
        } else {
            map.put(key, data);
        }
    }

    private void mapToProperties(String prefixName, Map<String, Object> properties, Object data) {
        if (data instanceof List) {
            List list = (List)data;
            for (int i = 0; i < list.size(); ++i) {
                int lastIndex = prefixName.lastIndexOf(46);
                String preName = prefixName.substring(0, lastIndex);
                String lastName = prefixName.substring(lastIndex);
                this.mapToProperties(preName + "[" + i + "]", properties, list.get(i));
            }
        } else if (data instanceof Map) {
            Map map = (Map)data;
            for (Map.Entry entry : map.entrySet()) {
                String tmpPrefix = StringUtils.isEmpty((Object)prefixName) ? (String)entry.getKey() : prefixName + "." + (String)entry.getKey();
                this.mapToProperties(tmpPrefix, properties, entry.getValue());
            }
        } else {
            properties.put(prefixName, String.valueOf(data));
        }
    }

    @Override
    public ConfigType supportType() {
        return ConfigType.XML;
    }
}

