/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.configcenter.nacos.config.loader;

import com.digiwin.configcenter.nacos.CustomizeConfigDefault;
import com.digiwin.configcenter.nacos.DWConfigFile;
import com.digiwin.configcenter.nacos.config.loader.AbstractConfigLoader;
import com.digiwin.configcenter.nacos.config.loader.ApplicationConfigLoader;
import com.digiwin.configcenter.nacos.properties.DAPNacosConfigProperty;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class CustomizeConfigLoader
extends AbstractConfigLoader {
    private static final Log logger = LogFactory.getLog(CustomizeConfigLoader.class);
    public static final Integer CONFIG_ORDER = ApplicationConfigLoader.CONFIG_ORDER - 1000;
    public static final String DAP_CUSTOMIZE_REMOTE_CONFIG_PREFIX = "dap.customize.remote.config.";

    @Override
    List<DWConfigFile> getConfigFile(ConfigurableEnvironment environment, DAPNacosConfigProperty dapNacosConfigProperty) {
        Binder binder = Binder.get((Environment)environment);
        BindResult customizeConfigDefaultResult = binder.bind("configcenter.nacos.customizedefault", Bindable.of(CustomizeConfigDefault.class));
        CustomizeConfigDefault customizeConfigDefault = customizeConfigDefaultResult.isBound() ? (CustomizeConfigDefault)customizeConfigDefaultResult.get() : CustomizeConfigDefault.DEFAULTINSTANCE;
        Properties customizeConfigproperties = null;
        BindResult customizePropertiesResult = binder.bind("configcenter.nacos.customizeconfig", Bindable.of(Properties.class));
        if (customizePropertiesResult.isBound()) {
            customizeConfigproperties = (Properties)customizePropertiesResult.get();
        } else {
            logger.info((Object)"CustomizeConfigLoader can't find any CustomizeConfigFile");
        }
        if (null == customizeConfigproperties) {
            return Collections.EMPTY_LIST;
        }
        Set<String> propertyNames = customizeConfigproperties.stringPropertyNames();
        Set files = propertyNames.stream().map(s -> {
            String[] split = s.split("\\.");
            if (null != split && split.length == 2) {
                return split[0];
            }
            return "";
        }).collect(Collectors.toSet());
        CustomizeConfigDefault finalCustomizeConfigDefault = customizeConfigDefault;
        List<DWConfigFile> customizeConfigFiles = files.stream().filter(fileName -> StringUtils.isNotBlank((CharSequence)fileName)).map(fileName -> {
            BindResult bind = Binder.get((Environment)environment).bind("configcenter.nacos.customizeconfig." + fileName, Bindable.of(DWConfigFile.class));
            if (bind.isBound()) {
                DWConfigFile configFile = (DWConfigFile)bind.get();
                configFile.setName((String)fileName);
                configFile.mergePropertie(finalCustomizeConfigDefault);
                return configFile;
            }
            return null;
        }).filter(configFile -> null != configFile).collect(Collectors.toList());
        return customizeConfigFiles;
    }

    @Override
    String getpropertySourceName(DWConfigFile configFile) {
        return "dap.customize.remote.config.#@#" + configFile.getGroup() + "#@#" + configFile.getName();
    }

    @Override
    public String getNameSpace(ConfigurableEnvironment environment) {
        return "";
    }

    @Override
    public int getOrder() {
        return CONFIG_ORDER;
    }
}

