/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.configcenter.nacos.properties;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;

public class NacosConfigPropertiesBuilder {
    public static Properties build(Environment environment, String serverAddr, String namespaceId, String endpoint, String secretKey, String accessKey, String ramRoleName, String configLongPollTimeout, String configRetryTimeout, String maxRetry, boolean enableRemoteSyncConfig, String username, String password) {
        Properties properties = new Properties();
        if (StringUtils.isNotEmpty((CharSequence)serverAddr)) {
            properties.put("serverAddr", environment.resolvePlaceholders(serverAddr));
        }
        if (StringUtils.isNotEmpty((CharSequence)namespaceId)) {
            properties.put("namespace", environment.resolvePlaceholders(namespaceId));
        }
        if (StringUtils.isNotEmpty((CharSequence)endpoint)) {
            properties.put("endpoint", environment.resolvePlaceholders(endpoint));
        }
        if (StringUtils.isNotEmpty((CharSequence)secretKey)) {
            properties.put("secretKey", environment.resolvePlaceholders(secretKey));
        }
        if (StringUtils.isNotEmpty((CharSequence)accessKey)) {
            properties.put("accessKey", environment.resolvePlaceholders(accessKey));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{ramRoleName})) {
            properties.put("ramRoleName", environment.resolvePlaceholders(ramRoleName));
        }
        if (StringUtils.isNotEmpty((CharSequence)configLongPollTimeout)) {
            properties.put("configLongPollTimeout", environment.resolvePlaceholders(configLongPollTimeout));
        }
        if (StringUtils.isNotEmpty((CharSequence)configRetryTimeout)) {
            properties.put("configRetryTime", environment.resolvePlaceholders(configRetryTimeout));
        }
        if (StringUtils.isNotEmpty((CharSequence)maxRetry)) {
            properties.put("maxRetry", environment.resolvePlaceholders(maxRetry));
        }
        if (StringUtils.isNotBlank((CharSequence)username)) {
            properties.put("username", environment.resolvePlaceholders(username));
        }
        if (StringUtils.isNotBlank((CharSequence)password)) {
            properties.put("password", environment.resolvePlaceholders(password));
        }
        properties.put("enableRemoteSyncConfig", String.valueOf(enableRemoteSyncConfig));
        return properties;
    }
}

