/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.configcenter.nacos.parse;

import com.alibaba.nacos.api.config.ConfigType;
import com.digiwin.configcenter.nacos.parse.NacosConfigParse;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.Yaml;

public class NacosYamlConfigParse
implements NacosConfigParse {
    @Override
    public Map<String, Object> parse(String context) {
        Yaml yaml = new Yaml();
        Object loaded = yaml.load(context);
        Map<String, Object> map = this.asMap(loaded);
        Map<String, Object> flattenedMap = this.getFlattenedMap(map);
        return flattenedMap;
    }

    protected static Yaml createYaml() {
        return new Yaml();
    }

    @Override
    public ConfigType supportType() {
        return ConfigType.YAML;
    }

    protected Map<String, Object> asMap(Object object) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (!(object instanceof Map)) {
            result.put("document", object);
            return result;
        }
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                value = this.asMap(value);
            }
            if (key instanceof CharSequence) {
                result.put(key.toString(), value);
                continue;
            }
            result.put("[" + key.toString() + "]", value);
        }
        return result;
    }

    protected Map<String, Object> getFlattenedMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.buildFlattenedMap(result, source, null);
        return result;
    }

    protected void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, String path) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (!StringUtils.isBlank((CharSequence)path)) {
                key = key.startsWith("[") ? path + key : path + '.' + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                result.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                this.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    this.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            result.put(key, value != null ? value.toString() : "");
        }
    }
}

