/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata;

import com.digiwin.app.metadata.DWAttribute;
import com.digiwin.app.metadata.DWNamedAttribute;
import com.digiwin.app.metadata.exceptions.DWAttributeNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DWAttributeCollection
implements Iterable<DWAttribute>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<DWAttribute> attributes = new ArrayList<DWAttribute>();

    @Override
    public Iterator<DWAttribute> iterator() {
        return this.attributes.iterator();
    }

    public void addAttribute(DWAttribute ... attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes is null!");
        }
        for (DWAttribute attribute : attributes) {
            if (attribute == null) continue;
            this.attributes.add(attribute);
        }
    }

    public <T extends DWAttribute> Collection<T> getAttributes(Class<? extends DWAttribute> dwAttributeType) {
        Collection matchedList = this.attributes.stream().filter(dwAttributeType::isInstance).map(attr -> attr).collect(Collectors.toList());
        return matchedList;
    }

    public <T extends DWAttribute> T getAttribute(String name) {
        DWAttribute targetAttribute = this.attributes.stream().filter(attr -> attr instanceof DWNamedAttribute && ((DWNamedAttribute)attr).getName().equals(name)).findFirst().orElse(null);
        if (targetAttribute == null) {
            throw new DWAttributeNotFoundException(name);
        }
        return (T)targetAttribute;
    }

    public boolean hasAttribute(String name) {
        return this.attributes.stream().anyMatch(a -> a instanceof DWNamedAttribute && ((DWNamedAttribute)a).getName().equalsIgnoreCase(name));
    }

    public void clear() {
        this.attributes.clear();
    }
}

