/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.data.DWDataSetConverter;
import com.digiwin.app.data.DWDataSetTableRowReferenceConverter;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.DWDataTableCollection;
import com.digiwin.app.data.exceptions.DWDataTableNotFoundException;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DWDataSet
implements Serializable {
    private static final String DEFAUL_CONVERTER_BEAN_ID = "DWDataSetConverter";
    private static DWDataSetConverter mapConverter = SpringContextUtils.containsBean((String)"DWDataSetConverter") ? (DWDataSetConverter)SpringContextUtils.getBean((String)"DWDataSetConverter") : new DWDataSetTableRowReferenceConverter();
    private DWDataTableCollection tables = new DWDataTableCollection(this);
    private Map<String, Object> sourceMap;
    private boolean syncDataSetToMap = true;

    protected void setDirty() {
        this.syncDataSetToMap = false;
    }

    public DWDataTableCollection getTables() {
        this.tables.setOwner(this);
        return this.tables;
    }

    public DWDataTable getTable(String name) {
        return this.getTable(name, true);
    }

    public DWDataTable getTable(String name, boolean throwExceptionIfNotFound) {
        DWDataTable targetTable = null;
        for (DWDataTable dt : this.getTables()) {
            if (!dt.getName().equals(name)) continue;
            targetTable = dt;
            break;
        }
        if (targetTable == null && throwExceptionIfNotFound) {
            throw new DWDataTableNotFoundException(name);
        }
        return targetTable;
    }

    public Map<String, Object> getSourceMap() {
        this.synchronizeToSourceMap();
        return this.sourceMap;
    }

    public void synchronizeToSourceMap() {
        if (!this.syncDataSetToMap) {
            this.sourceMap = mapConverter.toMap(this);
            this.syncDataSetToMap = true;
        }
    }

    @Deprecated
    public Map<String, Object> synchronizeToSourceMap(DWDataTable dataTable, List<Map<String, Object>> syncList) {
        return null;
    }

    public DWDataTable newTable(String name) {
        DWDataTable table = new DWDataTable(name);
        this.tables.add(table);
        return table;
    }

    public boolean containsTable(String name) {
        return this.tables.contains(name);
    }
}

