/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.datasource.utils;

import com.dap.component.dao.api.DaoConfigProvider;
import com.dap.component.dao.api.DaoModuleNameProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWMultipleDataSourcePropertiesUtil {
    private static Log _log = LogFactory.getLog(DWMultipleDataSourcePropertiesUtil.class);
    private static String _CLASSTAG = "[DWMultipleDataSourcePropertiesUtil] ";
    private static String paramFileName = "module";
    private static DWMultipleDataSourcePropertiesUtil multipleDataSourceUtil = new DWMultipleDataSourcePropertiesUtil();
    private static final String APPLICATION_CONFIG_PROPERTIES = "application";

    public static DWMultipleDataSourcePropertiesUtil paramFileName(String paramFileName) {
        DWMultipleDataSourcePropertiesUtil.paramFileName = paramFileName;
        return multipleDataSourceUtil;
    }

    public static String getSqlByParamKey(String key, String ... params) {
        String queryModuleName;
        if (params != null && params.length > 0) {
            queryModuleName = params[0];
        } else {
            DaoModuleNameProvider moduleNameProvider = (DaoModuleNameProvider)SpringContextUtils.getBean((String)"daoModuleNameProvider");
            queryModuleName = moduleNameProvider.getCurrentModuleName();
        }
        String propertiesName = "module";
        String daoMultipleDataSourceSupport = "";
        DaoConfigProvider configProvider = (DaoConfigProvider)SpringContextUtils.getBean((String)"daoConfigProvider");
        daoMultipleDataSourceSupport = queryModuleName != null ? configProvider.getModuleLayerValue(propertiesName, queryModuleName, key) : configProvider.getApplicationLayerValue(propertiesName, key);
        return daoMultipleDataSourceSupport;
    }

    public static Properties getMultipleDataSourceConfig() {
        DaoModuleNameProvider moduleNameProvider = (DaoModuleNameProvider)SpringContextUtils.getBean((String)"daoModuleNameProvider");
        String currentModuleName = moduleNameProvider.getCurrentModuleName();
        Properties configData = DWMultipleDataSourcePropertiesUtil.getMultipleDataSourceConfig(currentModuleName);
        return configData;
    }

    public static Properties getMultipleDataSourceProperties(String moduleName) {
        Properties result = null;
        DaoConfigProvider configProvider = (DaoConfigProvider)SpringContextUtils.getBean((String)"daoConfigProvider");
        result = StringUtils.isNotBlank((CharSequence)moduleName) ? configProvider.getModuleLayerProperties(paramFileName, moduleName) : configProvider.getApplicationLayerProperties(APPLICATION_CONFIG_PROPERTIES);
        return result;
    }

    public static Properties getMultipleDataSourceConfig(String moduleName) {
        String propertiesFileName = "";
        DaoConfigProvider configProvider = (DaoConfigProvider)SpringContextUtils.getBean((String)"daoConfigProvider");
        propertiesFileName = moduleName != null ? configProvider.getModuleLayerValue(paramFileName, moduleName, "daoMultipleDataSourceConfigProperties", "datasource-config.yaml") : configProvider.getApplicationLayerValue(paramFileName, "daoMultipleDataSourceConfigProperties", "datasource-config.yaml");
        Properties configData = DWMultipleDataSourcePropertiesUtil.getProperties(propertiesFileName);
        return configData;
    }

    public static Properties getMultipleDataSourceTenant() {
        DaoModuleNameProvider moduleNameProvider = (DaoModuleNameProvider)SpringContextUtils.getBean((String)"daoModuleNameProvider");
        String currentModuleName = moduleNameProvider.getCurrentModuleName();
        Properties tenantData = DWMultipleDataSourcePropertiesUtil.getMultipleDataSourceTenant(currentModuleName);
        return tenantData;
    }

    public static Properties getMultipleDataSourceTenant(String moduleName) {
        String propertiesFileName = "";
        DaoConfigProvider configProvider = (DaoConfigProvider)SpringContextUtils.getBean((String)"daoConfigProvider");
        propertiesFileName = moduleName != null ? configProvider.getModuleLayerValue(paramFileName, moduleName, "daoMultipleDataSourceTenantProperties", "datasource-tenant.yaml") : configProvider.getApplicationLayerValue(paramFileName, "daoMultipleDataSourceTenantProperties", "datasource-tenant.yaml");
        Properties tenantData = DWMultipleDataSourcePropertiesUtil.getProperties(propertiesFileName);
        return tenantData;
    }

    public static String getParamFileName() {
        return paramFileName;
    }

    private static Properties getProperties(String propertiesFileName) {
        Properties result = new Properties();
        if (StringUtils.isNotBlank((CharSequence)propertiesFileName)) {
            DaoConfigProvider configProvider = (DaoConfigProvider)SpringContextUtils.getBean((String)"daoConfigProvider");
            result = configProvider.getApplicationLayerProperties(DWMultipleDataSourcePropertiesUtil.removeExtensionName(propertiesFileName));
        }
        return result;
    }

    private static String removeExtensionName(String fileName) {
        if (fileName.contains(".")) {
            fileName = fileName.substring(0, fileName.indexOf("."));
        }
        return fileName;
    }
}

