/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import com.digiwin.app.data.IDWSQLOptions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;

public class DWQueryTimeoutQueryRunner
extends QueryRunner {
    public static final String QUERY_TIMEOUT = "queryTimeout";

    public DWQueryTimeoutQueryRunner() {
    }

    public DWQueryTimeoutQueryRunner(boolean pmdKnownBroken) {
        super(pmdKnownBroken);
    }

    public DWQueryTimeoutQueryRunner(DataSource ds) {
        super(ds);
    }

    public DWQueryTimeoutQueryRunner(DataSource ds, boolean pmdKnownBroken) {
        super(ds, pmdKnownBroken);
    }

    public int update(String sql, IDWSQLOptions option, Object ... params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.update(conn, true, sql, option, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int update(Connection conn, boolean closeConn, String sql, IDWSQLOptions option, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null SQL statement");
        }
        PreparedStatement stmt = null;
        int rows = 0;
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            int queryTimeout = option.get(QUERY_TIMEOUT, -1);
            if (queryTimeout > 0) {
                stmt.setQueryTimeout(queryTimeout);
            }
            rows = stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.rethrow(e, sql, params);
        }
        finally {
            this.close(stmt);
            if (closeConn) {
                this.close(conn);
            }
        }
        return rows;
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh, IDWSQLOptions option, Object ... params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.query(conn, true, sql, rsh, option, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T query(Connection conn, boolean closeConn, String sql, ResultSetHandler<T> rsh, IDWSQLOptions option, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (!closeConn) throw new SQLException("Null SQL statement");
            this.close(conn);
            throw new SQLException("Null SQL statement");
        }
        if (rsh == null) {
            if (!closeConn) throw new SQLException("Null ResultSetHandler");
            this.close(conn);
            throw new SQLException("Null ResultSetHandler");
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Object result = null;
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            int queryTimeout = option.get(QUERY_TIMEOUT, -1);
            if (queryTimeout > 0) {
                stmt.setQueryTimeout(queryTimeout);
            }
            rs = this.wrap(stmt.executeQuery());
            result = rsh.handle(rs);
            try {
                this.close(rs);
                return (T)result;
            }
            finally {
                this.close(stmt);
                if (closeConn) {
                    this.close(conn);
                }
            }
        }
        catch (SQLException e) {
            this.rethrow(e, sql, params);
            return (T)result;
        }
        finally {
            try {
                this.close(rs);
            }
            finally {
                this.close(stmt);
                if (closeConn) {
                    this.close(conn);
                }
            }
        }
    }
}

