/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.data.DWAutoIncrementOption;
import com.digiwin.app.data.generator.DWFieldValueGeneratorEnum;
import com.digiwin.app.data.generator.DWFieldValueGeneratorFactory;
import com.digiwin.app.data.generator.IDWFieldValueGenerator;
import java.util.ArrayList;
import java.util.List;

public class DWDataSetInsertOption {
    DWFieldValueGeneratorFactory generatorFactory;
    private DWAutoIncrementOption autoIncrementOption = new DWAutoIncrementOption();
    private List<DWFieldValueGeneratorSetting> fieldValueGeneratorSettings = new ArrayList<DWFieldValueGeneratorSetting>();

    public DWDataSetInsertOption() {
        this.generatorFactory = DWFieldValueGeneratorFactory.getInstance();
    }

    public DWAutoIncrementOption getAutoIncrementOption() {
        return this.autoIncrementOption;
    }

    public void addFieldValueGeneratorSetting(String fieldName, IDWFieldValueGenerator generator) {
        this.fieldValueGeneratorSettings.add(new DWFieldValueGeneratorSetting(fieldName, generator));
    }

    @Deprecated
    public void addFieldValueGeneratorSetting(String fieldName, GENERATOR_TYPE generatorType) {
        IDWFieldValueGenerator generator = this.generatorFactory.getGenerator(generatorType.getValue());
        this.fieldValueGeneratorSettings.add(new DWFieldValueGeneratorSetting(fieldName, generator));
    }

    public void addFieldValueGeneratorSetting(String fieldName, DWFieldValueGeneratorEnum generatorEnum) {
        IDWFieldValueGenerator generator = this.generatorFactory.getGenerator(generatorEnum.getValue());
        this.fieldValueGeneratorSettings.add(new DWFieldValueGeneratorSetting(fieldName, generator));
    }

    public List<DWFieldValueGeneratorSetting> getFieldValueGeneratorSettings() {
        return this.fieldValueGeneratorSettings;
    }

    @Deprecated
    public static enum GENERATOR_TYPE {
        UUID("uuid");

        private String value;

        private GENERATOR_TYPE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class DWFieldValueGeneratorSetting {
        private String fieldName;
        private IDWFieldValueGenerator generator;

        public DWFieldValueGeneratorSetting(String fieldName, IDWFieldValueGenerator generator) {
            this.fieldName = fieldName;
            this.generator = generator;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public IDWFieldValueGenerator getGenerator() {
            return this.generator;
        }

        public void setGenerator(IDWFieldValueGenerator generator) {
            this.generator = generator;
        }
    }
}

