/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.constraint;

import com.digiwin.app.dao.DWDataRowSqlInfo;
import com.digiwin.app.dao.constraint.DWConstraintFormatter;
import com.digiwin.app.dao.constraint.DWReferenceInformation;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.exceptions.DWDataDeleteConstraintException;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.metadata.rdbms.DWRdbmsRelationshipAttribute;
import java.util.List;

public class DWDeleteConstraint {
    public void check(DWDataRowSqlInfo sqlInfo, DWDataSetOperationOption option) throws Exception {
        this.check(sqlInfo.getRow(), option);
    }

    public void check(DWDataRow dataRow, DWDataSetOperationOption option) throws Exception {
        List<DWRdbmsRelationshipAttribute> relationshipAttributeList;
        String tableName = dataRow.getDataTable().getName();
        DWReferenceInformation dwReferenceInformation = new DWReferenceInformation(tableName);
        String hintMessage = "";
        if (DWRdbmsMetadata.hasConstraint(tableName).booleanValue() && (relationshipAttributeList = dwReferenceInformation.getRelationTableList()).size() > 0) {
            for (DWRdbmsRelationshipAttribute relationshipAttribute : relationshipAttributeList) {
                DWDataTable referenceDataList = dwReferenceInformation.getReferenceDataList(relationshipAttribute, dataRow, option);
                if (referenceDataList.getRows().size() <= 0) continue;
                hintMessage = hintMessage + DWConstraintFormatter.format(dwReferenceInformation.getTableDisplayName(relationshipAttribute.owner), dwReferenceInformation.getHintField(relationshipAttribute.owner), relationshipAttribute.getJoinColumns().keySet(), referenceDataList.getRows());
            }
            if (!hintMessage.isEmpty()) {
                hintMessage = hintMessage + "\u4f7f\u7528\u8a72\u7b46\u8cc7\u6599,\u7121\u6cd5\u522a\u9664!";
                throw new DWDataDeleteConstraintException(hintMessage);
            }
        }
    }
}

