/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.datasource;

import com.digiwin.app.dao.datasource.DWAbstractTenantDataSource;
import com.digiwin.app.dao.datasource.utils.DWTenantDataSourceUtils;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DWTenantRoutingDataSource
extends AbstractRoutingDataSource {
    private static Log _log = LogFactory.getLog(DWTenantRoutingDataSource.class);
    private static String _CLASSTAG = "[DWTenantRoutingDataSource] ";
    private DWAbstractTenantDataSource multipleDataSources;

    protected Object determineCurrentLookupKey() {
        String dsName = this.multipleDataSources.getDSNameFromRepository();
        _log.debug((Object)(_CLASSTAG + "determineCurrentLookupKey dsName=" + dsName));
        return dsName;
    }

    public DWAbstractTenantDataSource getMultipleDataSources() {
        return this.multipleDataSources;
    }

    public void setMultipleDataSources(DWAbstractTenantDataSource multipleDataSources) {
        this.multipleDataSources = multipleDataSources;
        HashMap<String, Object> dataSources = new HashMap<String, Object>();
        if (multipleDataSources != null) {
            Map localDataSources = (Map)multipleDataSources.getDataSources();
            for (String key : localDataSources.keySet()) {
                QueryRunner queryRunner = (QueryRunner)localDataSources.get(key);
                TransactionAwareDataSourceProxy dsProxy = (TransactionAwareDataSourceProxy)queryRunner.getDataSource();
                DataSource target = dsProxy.getTargetDataSource();
                dataSources.put(key, DWTenantDataSourceUtils.newDataSourceProxyInstance(target));
            }
            super.setTargetDataSources(dataSources);
        } else {
            _log.warn((Object)"multipleDataSources is null");
        }
    }

    public void setDefaultTargetDataSource(Object defaultTargetDataSource) {
        if (defaultTargetDataSource instanceof DataSource) {
            defaultTargetDataSource = DWTenantDataSourceUtils.newDataSourceProxyInstance((DataSource)defaultTargetDataSource);
        }
        super.setDefaultTargetDataSource(defaultTargetDataSource);
    }
}

