/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DWDriverConnectionFactory;

public class DWBasicDataSource
extends BasicDataSource {
    protected ConnectionFactory createConnectionFactory() throws SQLException {
        Driver driverToUse = this.getDriver();
        String driverClassName = this.getDriverClassName();
        ClassLoader driverClassLoader = this.getDriverClassLoader();
        String url = this.getUrl();
        if (driverToUse == null) {
            Class<?> driverFromCCL;
            block16: {
                driverFromCCL = null;
                if (driverClassName != null) {
                    try {
                        try {
                            if (driverClassLoader == null) {
                                driverFromCCL = Class.forName(driverClassName);
                                break block16;
                            }
                            driverFromCCL = Class.forName(driverClassName, true, driverClassLoader);
                        }
                        catch (ClassNotFoundException cnfe) {
                            driverFromCCL = Thread.currentThread().getContextClassLoader().loadClass(driverClassName);
                        }
                    }
                    catch (Exception t) {
                        String message = "Cannot load JDBC driver class '" + driverClassName + "'";
                        throw new SQLException(message, t);
                    }
                }
            }
            try {
                if (driverFromCCL == null) {
                    driverToUse = DriverManager.getDriver(url);
                } else {
                    driverToUse = (Driver)driverFromCCL.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!driverToUse.acceptsURL(url)) {
                        throw new SQLException("No suitable driver", "08001");
                    }
                }
            }
            catch (Exception t) {
                String message = "Cannot create JDBC driver of class '" + (driverClassName != null ? driverClassName : "") + "' for connect URL '" + url + "'";
                throw new SQLException(message, t);
            }
        }
        Properties connectionProperties = new Properties();
        String user = this.getUsername();
        if (user != null) {
            connectionProperties.put("user", user);
        } else {
            this.log("DBCP DataSource configured without a 'username'");
        }
        String pwd = this.getPassword();
        if (pwd != null) {
            connectionProperties.put("password", pwd);
        } else {
            this.log("DBCP DataSource configured without a 'password'");
        }
        DWDriverConnectionFactory driverConnectionFactory = new DWDriverConnectionFactory(driverToUse, url, connectionProperties);
        return driverConnectionFactory;
    }
}

