/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata;

import com.digiwin.app.metadata.DWMetadata;
import com.digiwin.app.metadata.exceptions.DWMetadataTypeNotMatchedException;
import com.digiwin.app.metadata.loader.DWMetadataLoaderManager;
import java.util.HashMap;
import java.util.Map;

public class DWMetadataContainer {
    private static Map<String, DWMetadata<?>> metadatas = new HashMap();
    private static Map<Long, Object> custMetadatas = new HashMap<Long, Object>();

    public static synchronized void add(DWMetadata<?> metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata is null or empty!");
        }
        metadatas.put(metadata.getName(), metadata);
    }

    public static DWMetadata<?> get(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is null or empty!");
        }
        return metadatas.get(name);
    }

    public static synchronized <T extends DWMetadata<?>> T get(String name, Class<? extends DWMetadata<?>> metadataType) {
        DWMetadata<?> metadata;
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is null or empty!");
        }
        if (metadatas.containsKey(name)) {
            metadata = metadatas.get(name);
        } else {
            metadata = DWMetadataLoaderManager.load(metadataType, name);
            DWMetadataContainer.add(metadata);
        }
        if (!metadataType.isInstance(metadata)) {
            throw new DWMetadataTypeNotMatchedException(name, metadataType.getName());
        }
        return (T)metadata;
    }

    public static synchronized <T extends DWMetadata<?>> T getUIMetadata(String programNo, Class<? extends DWMetadata<?>> metadataType) {
        return DWMetadataContainer.get(programNo, metadataType);
    }

    public static Map<String, Object> getCustMetadatas(Long tenantsid) {
        return (Map)custMetadatas.get(tenantsid);
    }

    public static void addCustMetadatas(Long tenantsid, Object newTableCustFieldDatas) {
        if (newTableCustFieldDatas != null && newTableCustFieldDatas instanceof Map) {
            HashMap tenantCurrentCustFields = (HashMap)custMetadatas.get(tenantsid);
            if (tenantCurrentCustFields == null) {
                tenantCurrentCustFields = new HashMap();
            }
            for (Map.Entry entry : ((Map)newTableCustFieldDatas).entrySet()) {
                String tableName = (String)entry.getKey();
                if (tenantCurrentCustFields.containsKey(tableName)) continue;
                tenantCurrentCustFields.put(tableName, entry.getValue());
                custMetadatas.put(tenantsid, tenantCurrentCustFields);
            }
        }
    }

    public static DWMetadata<?> remove(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is null or empty!");
        }
        return metadatas.remove(name);
    }
}

