/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.data.DWAutoIncrementOption;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import java.util.List;

public class DWDataRowSqlInfo
extends DWSqlInfo {
    private DWRdbmsMetadata metadata;
    private DWDataRow row;
    private int rowIndex;

    public DWDataRowSqlInfo(DWRdbmsMetadata metadata, DWDataRow row, String sql, List<Object> parameters) {
        super(sql, parameters);
        this.metadata = metadata;
        this.row = row;
    }

    public DWRdbmsMetadata getMetadata() {
        return this.metadata;
    }

    public DWDataRow getRow() {
        return this.row;
    }

    public String getTableName() {
        DWDataTable dataTable = this.getRow().getDataTable();
        return dataTable == null ? null : dataTable.getName();
    }

    public String getState() {
        return this.row.getState();
    }

    public void persist() {
        this.row.persist();
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Object updateAutoIncrementRefColumnValues(DWDataSetOperationOption option) {
        Object value = null;
        String tableName = this.getTableName();
        DWAutoIncrementOption.DWAutoIncrementSource valueSource = option.getInsertOption().getAutoIncrementOption().getSource(tableName);
        if (valueSource != null) {
            DWDataRow targetRow = this.getRow();
            DWDataRow sourceRow = targetRow.getParentRow();
            List<Object> parameters = this.getParametersAsList();
            for (int i = 0; i < parameters.size(); ++i) {
                if (!(parameters.get(i) instanceof DWAutoIncrementOption.DWAutoIncrementValueProxy)) continue;
                if (sourceRow == null) {
                    sourceRow = this.findImplicitParentRow(valueSource);
                }
                if (sourceRow == null) {
                    parameters.set(i, null);
                    throw new DWDataException("13016", String.format("Row(%s) has no parent row or explicit parent more than one!", targetRow));
                }
                DWAutoIncrementOption.DWAutoIncrementValueProxy valueProxy = (DWAutoIncrementOption.DWAutoIncrementValueProxy)parameters.get(i);
                value = this.updateAutoIncrementRefColumnValuesCore(i, sourceRow, valueProxy);
            }
        }
        return value;
    }

    protected Object updateAutoIncrementRefColumnValuesCore(int targetRowRefParameterIndex, DWDataRow sourceRow, DWAutoIncrementOption.DWAutoIncrementValueProxy valueProxy) {
        Object value = valueProxy.applyValue(sourceRow, this.getRow());
        this.getParametersAsList().set(targetRowRefParameterIndex, value);
        return value;
    }

    private DWDataRow findImplicitParentRow(DWAutoIncrementOption.DWAutoIncrementSource valueSource) {
        String sourceTable = valueSource.getSourceTable();
        DWDataRow sourceRow = null;
        DWDataSet dataSet = this.getRow().getDWDataSet();
        DWDataTable table = dataSet.getTable(sourceTable);
        if (table.getRows().size() == 1) {
            sourceRow = table.getRow(0);
        }
        return sourceRow;
    }
}

