/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.datasource;

import com.dap.component.dao.api.DaoModuleNameProvider;
import com.digiwin.app.dao.DWDaoImpl;
import com.digiwin.app.dao.datasource.DWAbstractTenantDataSource;
import com.digiwin.app.dao.datasource.DWDataSourceConstants;
import com.digiwin.app.dao.datasource.DWTenantDataSourceException;
import com.digiwin.app.dao.datasource.utils.DWMultipleDataSourcePropertiesUtil;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.DWBasicDataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

public class DWTenantDataSource
extends DWAbstractTenantDataSource {
    private static Log _log = LogFactory.getLog(DWTenantDataSource.class);
    private static String _CLASSTAG = "[DWTenantDataSource] ";
    private String tableDsConfig = "dw_datasource_config";
    private String tableDsTenant = "dw_datasource_tenant";
    private String columnDsName = "dsname";
    private String columnDsUrl = "dsurl";
    private String columnDsUsername = "username";
    private String columnDsPassword = "password";
    private String columnDsClassName = "dsclassname";
    private String columnDsConnectionProperties = "connectionproperties";
    private String columnDsType = "dstype";
    private String columnTenantSid = DWDataSourceConstants.COLUMN_TENANTSID;
    private String columnTenantDsName = "dsname";
    private String sourceBeanName = "dw-dao";
    private String datasourceConfigSql;
    private String datasourceTenantSql;

    public DWTenantDataSource() {
        this.initialize();
    }

    public DWTenantDataSource(String sourceBeanName) {
        this.sourceBeanName = sourceBeanName;
        this.initialize();
    }

    @Override
    public void initialize() {
        DaoModuleNameProvider moduleNameProvider = (DaoModuleNameProvider)SpringContextUtils.getBean((String)"daoModuleNameProvider");
        String currentModuleName = moduleNameProvider.getCurrentModuleName();
        this.initialize(currentModuleName);
    }

    @Override
    public void initialize(String moduleName) {
        boolean isConfigData = false;
        boolean isTenantData = false;
        try {
            DWDaoImpl dwdao = (DWDaoImpl)SpringContextUtils.getBean((String)this.sourceBeanName);
            if (dwdao != null) {
                DWDataSetOperationOption option = new DWDataSetOperationOption();
                option.setTenantEnabled(false);
                this.initSql(moduleName);
                List<Map<String, Object>> dbList = dwdao.select((IDWSQLOptions)option, this.datasourceConfigSql, new Object[0]);
                if (dbList != null && dbList.size() > 0) {
                    isConfigData = true;
                    HashMap<Object, QueryRunner> tempDataSources = new HashMap<Object, QueryRunner>();
                    for (Map<String, Object> row : dbList) {
                        String dsName = (String)row.get(this.columnDsName);
                        DataSource dataSource = this.createDataSource(row);
                        TransactionAwareDataSourceProxy transactionAwareDataSourceProxy = new TransactionAwareDataSourceProxy(dataSource);
                        QueryRunner queryRunner = new QueryRunner((DataSource)transactionAwareDataSourceProxy);
                        tempDataSources.put(row.get(this.columnDsName), queryRunner);
                        _log.debug((Object)(_CLASSTAG + " found dsname:" + String.valueOf(row.get(this.columnDsName))));
                    }
                    this.dataSources = tempDataSources;
                } else {
                    _log.debug((Object)(_CLASSTAG + "no data in datasourceConfigSql"));
                }
                if (isConfigData) {
                    List<Map<String, Object>> dbTenantList = dwdao.select((IDWSQLOptions)option, this.datasourceTenantSql, new Object[0]);
                    Map<Object, Object> tempDataSourceTenants = this.getTenantDataSourceNameRelation(dbTenantList);
                    if (tempDataSourceTenants != null && tempDataSourceTenants.size() > 0) {
                        isTenantData = true;
                        this.dataSourceTenants = tempDataSourceTenants;
                    }
                } else {
                    _log.debug((Object)(_CLASSTAG + "no data in datasourceTenantSql"));
                }
            } else {
                _log.warn((Object)(_CLASSTAG + this.sourceBeanName + " is null, ignore tenant multiple datasource"));
            }
            if (isConfigData && isTenantData) {
                this.multipleDatasouce = true;
            }
        }
        catch (Exception e) {
            _log.error((Object)(_CLASSTAG + "initialize error"), (Throwable)e);
        }
    }

    public void setDatasourceConfigSql(String datasourceConfigSql) {
        this.datasourceConfigSql = datasourceConfigSql;
    }

    public String getDatasourceConfigSql() {
        return this.datasourceConfigSql;
    }

    public String getDatasourceTenantSql() {
        return this.datasourceTenantSql;
    }

    public void setDatasourceTenantSql(String datasourceTenantSql) {
        this.datasourceTenantSql = datasourceTenantSql;
    }

    private void initSql(String moduleName) {
        String tempDatasourceConfigSql = DWMultipleDataSourcePropertiesUtil.getSqlByParamKey("daoMultipleDataSourceConfigSql", moduleName);
        String tempDatasourceTenantSql = DWMultipleDataSourcePropertiesUtil.getSqlByParamKey("daoMultipleDataSourceTenantSql", moduleName);
        if (StringUtils.isNotBlank((CharSequence)tempDatasourceConfigSql)) {
            this.setDatasourceConfigSql(tempDatasourceConfigSql);
        } else {
            this.datasourceConfigSql = "SELECT " + this.columnDsName + "," + this.columnDsUrl + "," + this.columnDsClassName + "," + this.columnDsUsername + "," + this.columnDsPassword + "," + this.columnDsConnectionProperties + "," + this.columnDsType + " FROM " + this.tableDsConfig;
        }
        if (StringUtils.isNotBlank((CharSequence)tempDatasourceTenantSql)) {
            this.setDatasourceTenantSql(tempDatasourceTenantSql);
        } else {
            this.datasourceTenantSql = "SELECT " + this.columnTenantSid + "," + this.columnTenantDsName + " FROM " + this.tableDsTenant;
        }
    }

    public Map<Object, Object> getTenantDataSourceNameRelation(List<Map<String, Object>> dbTenantList) {
        HashMap<Object, Object> retVal = new HashMap<Object, Object>();
        if (dbTenantList != null && dbTenantList.size() > 0) {
            for (Map<String, Object> row : dbTenantList) {
                retVal.put(row.get(this.columnTenantSid), row.get(this.columnTenantDsName));
                _log.debug((Object)(_CLASSTAG + " found tenant-dsname(" + String.valueOf(row.get(this.columnTenantSid)) + "," + String.valueOf(row.get(this.columnTenantDsName)) + ")"));
            }
        }
        return retVal;
    }

    private DataSource createDataSource(Map<String, Object> dbItem) {
        Object dataSource = null;
        Object dataSourceTypeObj = dbItem.get(this.columnDsType);
        if (Objects.isNull(dataSourceTypeObj) || StringUtils.isBlank((CharSequence)dataSourceTypeObj.toString())) {
            dataSource = new DWBasicDataSource();
        } else {
            try {
                Class<?> dataSourceType = Class.forName(dataSourceTypeObj.toString());
                dataSource = (DataSource)dataSourceType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new DWTenantDataSourceException("Failed to create DataSource['" + String.valueOf(dataSourceTypeObj) + "'] instance", e);
            }
        }
        this.setProperties((DataSource)dataSource, dbItem);
        return dataSource;
    }

    private void setProperties(DataSource dataSource, Map<String, Object> dbItem) {
        Object driverClassNameVal = dbItem.get(this.columnDsClassName);
        Object urlVal = dbItem.get(this.columnDsUrl);
        Object usernameVal = dbItem.get(this.columnDsUsername);
        Object passwordVal = dbItem.get(this.columnDsPassword);
        super.validDataSourceBaseProperty(driverClassNameVal, urlVal, usernameVal, passwordVal);
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl((Object)dataSource);
        beanWrapper.setPropertyValue("driverClassName", (Object)driverClassNameVal.toString());
        beanWrapper.setPropertyValue("url", (Object)urlVal.toString());
        beanWrapper.setPropertyValue("username", (Object)usernameVal.toString());
        beanWrapper.setPropertyValue("password", (Object)passwordVal.toString());
        Object connectionOptionsVal = dbItem.get(this.columnDsConnectionProperties);
        if (Objects.isNull(connectionOptionsVal)) {
            return;
        }
        Map<String, Object> connectionOptions = super.convertConnectionPropertiesToMap(connectionOptionsVal.toString());
        for (Map.Entry<String, Object> entry : connectionOptions.entrySet()) {
            String propertyName = entry.getKey();
            Object propertyValue = entry.getValue();
            Method setterMethod = super.findSetterMethod(dataSource, propertyName);
            if (ArrayUtils.isEmpty((Object[])setterMethod.getParameterTypes())) {
                throw new DWTenantDataSourceException("DataSource property '" + propertyName + "' setter method not found.");
            }
            Object fieldValue = super.convertPropertyValue(propertyValue, setterMethod.getParameterTypes()[0]);
            beanWrapper.setPropertyValue(propertyName, fieldValue);
        }
    }
}

