/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.dialect;

import com.digiwin.app.dao.DWBatchDataRowSqlInfo;
import com.digiwin.app.dao.DWDataRowSqlInfo;
import com.digiwin.app.data.DWDataOptimisticLockingInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import java.util.List;

public class DWSQLParseInfo {
    private int insertRowIndex = -1;
    private int updateRowIndex = -1;
    private int deleteRowIndex = -1;
    private DWBatchDataRowSqlInfo firstInsertRowInfo;
    private DWBatchDataRowSqlInfo firstUpdateRowInfo;
    private DWBatchDataRowSqlInfo firstDeleteRowInfo;
    private boolean batchMode = false;
    private int rowCount = 0;

    public DWSQLParseInfo() {
        this(10);
    }

    public DWSQLParseInfo(int totalRowCount) {
        this.rowCount = totalRowCount;
    }

    public void setInsert() {
        ++this.insertRowIndex;
    }

    public void setUpdate() {
        ++this.updateRowIndex;
    }

    public void setDelete() {
        ++this.deleteRowIndex;
    }

    public boolean isFirstInsert() {
        return this.insertRowIndex == 0;
    }

    public boolean isFirstUpdate() {
        return this.updateRowIndex == 0;
    }

    public boolean isFirstDelete() {
        return this.deleteRowIndex == 0;
    }

    public void setBatchMode(boolean batch) {
        this.batchMode = batch;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public DWDataRowSqlInfo createInsertSqlInfo(DWRdbmsMetadata metadata, DWDataRow row, String sql, List<Object> parameters, List<String> columnNameMappingList) {
        DWDataRowSqlInfo sqlInfo = null;
        if (this.batchMode) {
            if (this.isFirstInsert()) {
                this.firstInsertRowInfo = new DWBatchDataRowSqlInfo(metadata, this.rowCount, row, sql, parameters, columnNameMappingList, null);
                sqlInfo = this.firstInsertRowInfo;
            } else {
                this.firstInsertRowInfo.addBatch(row, parameters, columnNameMappingList);
            }
        } else {
            sqlInfo = this.createDefaultSqlInfo(metadata, row, sql, parameters, null);
        }
        return sqlInfo;
    }

    public DWDataRowSqlInfo createUpdateSqlInfo(DWRdbmsMetadata metadata, DWDataRow row, String sql, List<Object> parameters, List<String> columnNameMappingList, DWDataOptimisticLockingInfo lockingInfo) {
        DWDataRowSqlInfo sqlInfo = null;
        if (this.batchMode) {
            if (this.isFirstUpdate()) {
                this.firstUpdateRowInfo = new DWBatchDataRowSqlInfo(metadata, this.rowCount, row, sql, parameters, columnNameMappingList, lockingInfo);
                this.firstUpdateRowInfo.setLockingInfo(lockingInfo);
                sqlInfo = this.firstUpdateRowInfo;
            } else {
                this.firstUpdateRowInfo.addBatch(row, parameters, columnNameMappingList, lockingInfo);
            }
        } else {
            sqlInfo = this.createDefaultSqlInfo(metadata, row, sql, parameters, lockingInfo);
        }
        return sqlInfo;
    }

    public DWDataRowSqlInfo createDeleteSqlInfo(DWRdbmsMetadata metadata, DWDataRow row, String sql, List<Object> parameters, List<String> columnNameMappingList, DWDataOptimisticLockingInfo lockingInfo) {
        DWDataRowSqlInfo sqlInfo = null;
        if (this.batchMode) {
            if (this.isFirstDelete()) {
                this.firstDeleteRowInfo = new DWBatchDataRowSqlInfo(metadata, this.rowCount, row, sql, parameters, columnNameMappingList, lockingInfo);
                this.firstDeleteRowInfo.setLockingInfo(lockingInfo);
                sqlInfo = this.firstDeleteRowInfo;
            } else {
                this.firstDeleteRowInfo.addBatch(row, parameters, columnNameMappingList, lockingInfo);
            }
        } else {
            sqlInfo = this.createDefaultSqlInfo(metadata, row, sql, parameters, lockingInfo);
        }
        return sqlInfo;
    }

    private DWDataRowSqlInfo createDefaultSqlInfo(DWRdbmsMetadata metadata, DWDataRow row, String sql, List<Object> parameters, DWDataOptimisticLockingInfo lockingInfo) {
        DWDataRowSqlInfo sqlInfo = new DWDataRowSqlInfo(metadata, row, sql, parameters);
        sqlInfo.setLockingInfo(lockingInfo);
        return sqlInfo;
    }
}

