/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.processor;

import com.digiwin.app.dao.annotation.DbField;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.dbutils.GenerousBeanProcessor;

public class DWGenerousBeanProcessor
extends GenerousBeanProcessor {
    public <T> T toBean(ResultSet rs, Class<T> type) throws SQLException {
        Object bean = super.toBean(rs, type);
        this.processDbField(rs, type, bean);
        return (T)bean;
    }

    public <T> List<T> toBeanList(ResultSet rs, Class<T> type) throws SQLException {
        ArrayList<T> results = new ArrayList<T>();
        if (!rs.next()) {
            return results;
        }
        do {
            results.add(this.toBean(rs, type));
        } while (rs.next());
        return results;
    }

    private <T> void processDbField(ResultSet rs, Class<T> type, T bean) throws SQLException {
        Field[] fields;
        for (Field field : fields = type.getDeclaredFields()) {
            DbField dbField = field.getAnnotation(DbField.class);
            if (!Objects.nonNull(dbField)) continue;
            String columnName = dbField.value();
            Object value = rs.getObject(columnName);
            field.setAccessible(true);
            try {
                field.set(bean, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to set annotated field", e);
            }
        }
    }
}

