/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetConverter;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.DWReferenceDataRowCollection;
import com.digiwin.app.data.DWRowHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DWDataSetTableRowReferenceConverter
implements DWDataSetConverter {
    @Override
    public Map<String, Object> toMap(DWDataSet dataset) {
        HashMap<String, Object> syncMap = new HashMap<String, Object>();
        HashMap<String, Object> custTableColumnsMap = new HashMap<String, Object>();
        for (DWDataTable tb : dataset.getTables()) {
            String tableName = tb.getName();
            ArrayList<Map<String, Object>> tableRowList = new ArrayList<Map<String, Object>>();
            syncMap.put(tableName, tableRowList);
            Map<String, Object> custColumnsMap = tb.getCustColumns();
            if (custColumnsMap != null && custColumnsMap.containsKey(tableName)) {
                custTableColumnsMap.put(tableName, custColumnsMap.get(tableName));
            }
            this.synchronizeToSourceMap(tb.getRows(), tableRowList);
        }
        if (custTableColumnsMap != null && custTableColumnsMap.size() > 0) {
            syncMap.put("$custFieldsConfig", custTableColumnsMap);
        }
        return syncMap;
    }

    protected void synchronizeToSourceMap(DWDataRowCollection rowCollection, List<Map<String, Object>> tableRowList) {
        Iterator<DWDataRow> removedRows = rowCollection.getIteratorOfRemovedRows();
        boolean isReferenceRow = rowCollection instanceof DWReferenceDataRowCollection;
        while (removedRows.hasNext()) {
            this.synchronizeToSourceMap(isReferenceRow, removedRows.next(), tableRowList);
        }
        for (DWDataRow row : rowCollection) {
            this.synchronizeToSourceMap(isReferenceRow, row, tableRowList);
        }
    }

    protected void synchronizeToSourceMap(boolean isReferenceRow, DWDataRow processRow, List<Map<String, Object>> tableRowList) {
        if (isReferenceRow || processRow.getParentRow() == null) {
            Map<String, Object> rawRawData = this.getRawDataMap(processRow.getSourceData());
            tableRowList.add(rawRawData);
        }
    }

    protected Map<String, Object> getRawDataMap(Map<String, Object> rowSourceData) {
        DWRowHashMap rawMap = new DWRowHashMap();
        rawMap.putAll(rowSourceData);
        for (Map.Entry item : rawMap.entrySet()) {
            if (!(item.getValue() instanceof DWDataRowCollection)) continue;
            ArrayList<Map<String, Object>> childRowRawDataList = new ArrayList<Map<String, Object>>();
            this.synchronizeToSourceMap((DWDataRowCollection)item.getValue(), childRowRawDataList);
            rawMap.put((String)item.getKey(), childRowRawDataList);
        }
        return rawMap;
    }
}

