/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.data.IDWSQLOptions;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DWMapSQLOptions
implements IDWSQLOptions {
    private Map<String, Object> options = new HashMap<String, Object>();

    @Override
    public void set(String optionName, Object optionValue) {
        Objects.requireNonNull(optionName);
        this.options.put(optionName, optionValue);
    }

    @Override
    public <T> T get(String optionName) {
        return this.get(optionName, null);
    }

    @Override
    public <T> T get(String optionName, T defaultValue) {
        Objects.requireNonNull(optionName);
        Map<String, Object> value = null;
        String[] paths = optionName.split("\\.");
        try {
            Object currentObject = this.options;
            for (int i = 0; i < paths.length && (currentObject = this.getPathObject(currentObject, paths[i])) != null; ++i) {
            }
            value = currentObject;
        }
        catch (Exception e) {
            new DWRuntimeException("\u4e0d\u6b63\u78ba\u7684\u9078\u9805\u8def\u5f91", (Throwable)e);
        }
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    private Object getPathObject(Object currentObject, String path) throws Exception {
        if (path == null || path.isEmpty()) {
            throw new DWException("\u8def\u5f91\u4e0d\u53ef\u70ba\u7a7a!");
        }
        if (currentObject == null) {
            return null;
        }
        int targetItemIndex = -1;
        boolean isGetCollectionItemMode = false;
        if (path.contains("[") && path.endsWith("]")) {
            isGetCollectionItemMode = true;
            int startIndex = path.indexOf("[") + 1;
            String indexString = path.substring(startIndex, path.length() - 1);
            targetItemIndex = Integer.parseInt(indexString);
            path = path.substring(0, startIndex - 1);
        }
        Object pathObject = null;
        if (currentObject instanceof Map) {
            pathObject = ((Map)currentObject).get(path);
        } else {
            Field field = currentObject.getClass().getDeclaredField(path);
            field.setAccessible(true);
            pathObject = field.get(currentObject);
        }
        if (isGetCollectionItemMode) {
            if (pathObject == null) {
                throw new DWException("path object is null, can not get target index(" + targetItemIndex + ") item!");
            }
            if (!(pathObject instanceof List)) {
                throw new DWException("path object is not Collection, real type is " + String.valueOf(pathObject.getClass()));
            }
            pathObject = ((List)pathObject).get(targetItemIndex);
        }
        return pathObject;
    }
}

