/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.ddl;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.ddl.enums.IndexEnum;
import com.digiwin.app.ddl.model.DDLResult;
import com.digiwin.app.ddl.model.Field;
import com.digiwin.app.ddl.model.Table;
import com.digiwin.app.ddl.util.DDLGenerator;
import com.digiwin.app.ddl.util.MetadataSqlGenerator;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DWMetadataUtil {
    private static Log log = LogFactory.getLog(DWMetadataUtil.class);

    DWMetadataUtil() {
    }

    public static DDLResult createTable(@NotNull DWDao dao, @NotNull Table table, @Nullable Boolean dropFirst, @Nullable Boolean executeSql) throws Exception {
        ArrayList<String> sqlList = new ArrayList<String>();
        if (Objects.isNull(dropFirst)) {
            dropFirst = true;
        }
        sqlList.addAll(DDLGenerator.createTable(table, dropFirst));
        if (dropFirst.booleanValue()) {
            sqlList.addAll(MetadataSqlGenerator.deleteTable(table.getTableName()));
        }
        sqlList.addAll(MetadataSqlGenerator.createTable(table));
        List<Boolean> executeResult = DWMetadataUtil.executeSql(dao, sqlList, executeSql);
        return new DDLResult(executeResult, sqlList);
    }

    public static DDLResult deleteTable(@NotNull DWDao dao, @NotNull String tableName, @Nullable Boolean executeSql) throws Exception {
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(DDLGenerator.deleteTable(tableName));
        sqlList.addAll(MetadataSqlGenerator.deleteTable(tableName));
        List<Boolean> executeResult = DWMetadataUtil.executeSql(dao, sqlList, executeSql);
        return new DDLResult(executeResult, sqlList);
    }

    public static DDLResult addColumn(@NotNull DWDao dao, @NotNull String tableName, @NotNull List<Field> fieldList, @Nullable Boolean executeSql) throws Exception {
        List<String> pks = DWMetadataUtil.getPrimaryKeys(dao, tableName);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(DDLGenerator.addColumn(tableName, fieldList, pks));
        int beginSeq = DWMetadataUtil.getNextSeq(dao, tableName);
        sqlList.add(MetadataSqlGenerator.insertFields(tableName, fieldList, beginSeq));
        List<Boolean> executeResult = DWMetadataUtil.executeSql(dao, sqlList, executeSql);
        return new DDLResult(executeResult, sqlList);
    }

    public static DDLResult modifyColumn(@NotNull DWDao dao, @NotNull String tableName, @NotNull List<Field> fieldList, @Nullable Boolean executeSql) throws Exception {
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(DDLGenerator.modifyColumn(tableName, fieldList));
        sqlList.addAll(MetadataSqlGenerator.updateFields(tableName, fieldList));
        List<Boolean> executeResult = DWMetadataUtil.executeSql(dao, sqlList, executeSql);
        return new DDLResult(executeResult, sqlList);
    }

    public static DDLResult deleteColumn(@NotNull DWDao dao, @NotNull String tableName, @NotNull List<String> columnNames, @Nullable Boolean executeSql) throws Exception {
        List<String> pks = DWMetadataUtil.getPrimaryKeys(dao, tableName);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(DDLGenerator.deleteColumn(tableName, columnNames, pks));
        sqlList.addAll(MetadataSqlGenerator.deleteFields(tableName, columnNames));
        List<Boolean> executeResult = DWMetadataUtil.executeSql(dao, sqlList, executeSql);
        return new DDLResult(executeResult, sqlList);
    }

    public static DDLResult setColumnIntoPrimaryKey(@NotNull DWDao dao, @NotNull String tableName, @NotNull List<String> columnNames, @Nullable Boolean executeSql) throws Exception {
        List<String> pks = DWMetadataUtil.getPrimaryKeys(dao, tableName);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(DDLGenerator.setColumnIntoPrimaryKey(tableName, columnNames, pks));
        sqlList.addAll(MetadataSqlGenerator.setColumnIsPrimaryKey(tableName, columnNames));
        List<Boolean> executeResult = DWMetadataUtil.executeSql(dao, sqlList, executeSql);
        return new DDLResult(executeResult, sqlList);
    }

    public static DDLResult createIndex(@NotNull DWDao dao, @NotNull String tableName, @NotNull IndexEnum indexEnum, @Nullable String indexName, @NotNull List<String> columnNames, @Nullable Boolean executeSql) throws Exception {
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(DDLGenerator.createIndex(tableName, indexEnum, indexName, columnNames));
        List<Boolean> executeResult = DWMetadataUtil.executeSql(dao, sqlList, executeSql);
        return new DDLResult(executeResult, sqlList);
    }

    public static DDLResult deleteIndex(@NotNull DWDao dao, @NotNull String tableName, @NotNull List<String> columnNames, @Nullable Boolean executeSql) throws Exception {
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(DDLGenerator.deleteIndex(tableName, columnNames));
        List<Boolean> executeResult = DWMetadataUtil.executeSql(dao, sqlList, executeSql);
        return new DDLResult(executeResult, sqlList);
    }

    public static DDLResult deleteIndex(@NotNull DWDao dao, @NotNull String tableName, @NotNull String indexName, @Nullable Boolean executeSql) throws Exception {
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(DDLGenerator.deleteIndex(tableName, indexName));
        List<Boolean> executeResult = DWMetadataUtil.executeSql(dao, sqlList, executeSql);
        return new DDLResult(executeResult, sqlList);
    }

    static List<Boolean> executeSql(DWDao dao, List<String> sqlList, Boolean executeSql) throws Exception {
        ArrayList<Boolean> resultList = new ArrayList<Boolean>();
        if (Objects.isNull(executeSql)) {
            executeSql = true;
        }
        if (executeSql.booleanValue()) {
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setManagementFieldEnabled(false);
            option.setTenantEnabled(false);
            for (String sql : sqlList) {
                try {
                    dao.update((IDWSQLOptions)option, sql, new Object[0]);
                    resultList.add(true);
                }
                catch (Exception e) {
                    log.error((Object)("execute sql[" + sql + "] error"), (Throwable)e);
                    resultList.add(false);
                }
            }
        }
        return resultList;
    }

    static List<String> getPrimaryKeys(DWDao dao, String tableName) throws Exception {
        String sql = MetadataSqlGenerator.getPrimaryKey(tableName);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        ArrayList<String> pks = new ArrayList<String>();
        List result = dao.select((IDWSQLOptions)option, sql, new Object[0]);
        for (Map map : result) {
            Object pk = map.get("pk");
            if (!Objects.nonNull(pk)) continue;
            pks.add(Objects.toString(pk));
        }
        return pks;
    }

    static int getNextSeq(DWDao dao, String tableName) throws Exception {
        Object seq;
        String sql = MetadataSqlGenerator.getNextSeq(tableName);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        List result = dao.select((IDWSQLOptions)option, sql, new Object[0]);
        Map map = (Map)result.get(0);
        if (Objects.nonNull(map) && Objects.nonNull(seq = map.get("seq"))) {
            return Integer.parseInt(Objects.toString(seq));
        }
        return -1;
    }
}

