/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data.generator;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SnowFlakeUtil {
    private static Log log = LogFactory.getLog(SnowFlakeUtil.class);
    private long workerId;
    private long datacenterId;
    private long sequence;
    private static final long twepoch = 1689751691344L;
    private static final long TIME_BIT = -4194304L;
    private static final long workerIdBits = 5L;
    private static final long datacenterIdBits = 5L;
    private static final long sequenceBits = 12L;
    private static final long maxWorkerId = 31L;
    private static final long maxDatacenterId = 31L;
    private static final long workerIdShift = 12L;
    private static final long datacenterIdShift = 17L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 4095L;
    private long lastTimestamp = -1L;
    private boolean isBackwordsFlag = false;
    private boolean isFirstBackwordsFlag = true;
    private long backBaseTimestamp = -1L;

    public static synchronized SnowFlakeUtil getInstance() {
        return SnowFlakeUtilInstance.instance;
    }

    public long getTimestamp() {
        return System.currentTimeMillis();
    }

    public SnowFlakeUtil() {
        this.datacenterId = SnowFlakeUtil.getDatacenterId(31L);
        this.workerId = SnowFlakeUtil.getMaxWorkerId(this.datacenterId, 31L);
        log.info((Object)String.format("init SnowFlakeUtil success! datacenterId=%d , workerId=%d", this.datacenterId, this.workerId));
    }

    public SnowFlakeUtil(long workerId, long datacenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (datacenterId > 31L || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    protected static long getMaxWorkerId(long datacenterId, long maxWorkerId) {
        StringBuffer mpid = new StringBuffer();
        mpid.append(datacenterId);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (!name.isEmpty()) {
            mpid.append(name.split("@")[0]);
        }
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    protected static long getDatacenterId(long maxDatacenterId) {
        long id;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                id = (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)mac[mac.length - 2] << 8) >> 6;
                id %= maxDatacenterId + 1L;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return id;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (this.isBackwordsFlag) {
            if (timestamp >= this.backBaseTimestamp && timestamp < this.lastTimestamp) {
                timestamp = this.lastTimestamp;
            } else if (timestamp > this.lastTimestamp) {
                this.isBackwordsFlag = false;
                this.isFirstBackwordsFlag = true;
                log.info((Object)("\u65f6\u95f4\u5df2\u6062\u590d\u6b63\u5e38-->" + timestamp));
            }
        }
        if (timestamp < this.lastTimestamp) {
            log.error((Object)String.format("Clock moved backwards. lastTimestamp=%d, timestamp=%d, l-t=%d \n", this.lastTimestamp, timestamp, this.lastTimestamp - timestamp));
            timestamp = this.lastTimestamp;
            this.isBackwordsFlag = true;
            if (this.isFirstBackwordsFlag) {
                this.backBaseTimestamp = timestamp;
                this.isFirstBackwordsFlag = false;
                log.error((Object)("\u65f6\u949f\u56de\u62e8\u5df2\u53d1\u751f-->" + this.backBaseTimestamp));
            }
        }
        if (timestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                if (this.isBackwordsFlag) {
                    log.info((Object)"sequence \u5df2\u8d85\u8fc7\u9608\u503c\uff0clastTimestamp++");
                    timestamp = ++this.lastTimestamp;
                } else {
                    log.info((Object)"sequence \u5df2\u8d85\u8fc7\u9608\u503c\uff0c\u7b49\u5f85\u8fdb\u5165\u4e0b\u4e00\u6beb\u79d2");
                    timestamp = this.tilNextMillis(this.lastTimestamp);
                }
            }
        } else {
            this.sequence = timestamp & 1L;
        }
        if (!this.isBackwordsFlag) {
            this.lastTimestamp = timestamp;
        }
        return timestamp - 1689751691344L << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public static Date getTimeBySnowFlakeId(long id) {
        return new Date(((0xFFFFFFFFFFC00000L & id) >> 22) + 1689751691344L);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        SnowFlakeUtil snowFlow = new SnowFlakeUtil(1L, 1L);
        int count = 10000000;
        for (int i = 0; i < count; ++i) {
            snowFlow.nextId();
            Thread.sleep(100L);
        }
        System.out.println(System.currentTimeMillis());
        DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String dateString = "2015-01-01 00:00:00";
        LocalDateTime localDateTime = LocalDateTime.parse(dateString, dtf2);
        System.out.println(localDateTime.toInstant(ZoneOffset.ofHours(8)).toEpochMilli());
    }

    private static void testClockMvoedBackwords(long seconds) throws IOException {
        System.out.println(LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss")));
        LocalDateTime localDateTime = LocalDateTime.now();
        String backTime = localDateTime.minusSeconds(seconds).format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        System.out.println(backTime);
        if (System.getProperty("os.name").contains("Windows")) {
            String cmd = "cmd /c start time 15:41:56";
            Runtime.getRuntime().exec(cmd);
            System.out.println(LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss")));
        }
    }

    private static class SnowFlakeUtilInstance {
        private static final SnowFlakeUtil instance = new SnowFlakeUtil();

        private SnowFlakeUtilInstance() {
        }
    }
}

