/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.ddl.util;

import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.app.ddl.enums.IndexEnum;
import com.digiwin.app.ddl.model.Field;
import com.digiwin.app.ddl.model.Table;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class DDLGenerator {
    DDLGenerator() {
    }

    public static List<String> createTable(@NotNull Table table, Boolean dropFirst) throws Exception {
        String collate;
        String tableName = table.getTableName();
        ArrayList<String> sqlList = new ArrayList<String>();
        if (dropFirst.booleanValue()) {
            sqlList.add(DDLGenerator.deleteTable(tableName));
        }
        StringBuilder sql = new StringBuilder(String.format("CREATE TABLE `%s` ", tableName));
        StringBuilder fieldsSql = new StringBuilder("(");
        ArrayList<String> primaryKeys = new ArrayList<String>();
        for (Field field : table.getFields()) {
            String columnName = field.getColumnName();
            if (field.isPK().booleanValue()) {
                primaryKeys.add(columnName);
            }
            fieldsSql.append(DDLGenerator.generateFiledSql(field));
        }
        fieldsSql.append(DDLGenerator.generatePK(primaryKeys, false));
        fieldsSql = new StringBuilder(fieldsSql.substring(0, fieldsSql.length() - 1)).append(")");
        sql.append((CharSequence)fieldsSql);
        String comment = table.getComment();
        if (Objects.nonNull(comment)) {
            sql.append(String.format("COMMENT='%s' ", comment));
        }
        if (Objects.nonNull(collate = table.getCollate())) {
            sql.append(String.format("COLLATE='%s' ", collate));
        }
        sqlList.add(sql.append(";").toString());
        return sqlList;
    }

    public static String deleteTable(@NotNull String tableName) throws Exception {
        return String.format("DROP TABLE IF EXISTS `%s`;", tableName);
    }

    public static String addColumn(@NotNull String tableName, @NotNull List<Field> fieldList, List<String> pks) throws Exception {
        StringBuilder sql = new StringBuilder(String.format("ALTER TABLE `%s` ", tableName));
        StringBuilder fields = new StringBuilder();
        HashSet<String> primaryKeys = new HashSet<String>();
        for (Field field : fieldList) {
            fields.append("ADD COLUMN ").append(DDLGenerator.generateFiledSql(field));
            String columnName = field.getColumnName();
            if (!field.isPK().booleanValue()) continue;
            primaryKeys.add(columnName);
        }
        if (!primaryKeys.isEmpty()) {
            if (Objects.isNull(pks) || pks.isEmpty()) {
                throw new RuntimeException(String.format("data table [%s] primary key is null \uff01", tableName));
            }
            fields.append("DROP PRIMARY KEY,");
            pks.addAll(primaryKeys);
            String pkSql = DDLGenerator.generatePK(pks, true);
            fields.append(pkSql.substring(0, pkSql.length() - 1)).append(",");
        }
        sql.append(fields.substring(0, fields.length() - 1));
        return sql.append(";").toString();
    }

    public static String modifyColumn(@NotNull String tableName, @NotNull List<Field> fieldList) throws Exception {
        StringBuilder sql = new StringBuilder(String.format("ALTER TABLE `%s` ", tableName));
        StringBuilder fields = new StringBuilder();
        for (Field field : fieldList) {
            String columnName = field.getColumnName();
            fields.append(String.format("CHANGE COLUMN `%s` ", columnName));
            fields.append(DDLGenerator.generateFiledSql(field));
        }
        sql.append(fields.substring(0, fields.length() - 1));
        return sql.append(";").toString();
    }

    public static String deleteColumn(@NotNull String tableName, @NotNull List<String> columnNames, @NotNull List<String> pks) throws Exception {
        StringBuilder sql = new StringBuilder(String.format("ALTER TABLE `%s` ", tableName));
        ArrayList<String> deletePK = new ArrayList<String>();
        boolean needProcessPK = false;
        for (String string : columnNames) {
            if (!pks.contains(string)) continue;
            deletePK.add(string);
            needProcessPK = true;
        }
        if (needProcessPK) {
            sql.append("DROP PRIMARY KEY,");
            ArrayList<String> newPK = new ArrayList<String>();
            for (String pk : pks) {
                if (deletePK.contains(pk)) continue;
                newPK.add(pk);
            }
            String string = DDLGenerator.generatePK(newPK, true);
            sql.append(string);
        }
        StringBuilder fields = new StringBuilder();
        for (String columnName : columnNames) {
            fields.append(String.format("DROP COLUMN `%s`,", columnName));
        }
        sql.append(fields.substring(0, fields.length() - 1));
        return sql.append(";").toString();
    }

    public static String setColumnIntoPrimaryKey(@NotNull String tableName, @NotNull List<String> columnNames, @NotNull List<String> pks) throws Exception {
        StringBuilder sql = new StringBuilder(String.format("ALTER TABLE `%s` ", tableName));
        sql.append("DROP PRIMARY KEY,");
        pks.addAll(columnNames);
        String pkSql = DDLGenerator.generatePK(pks, true);
        sql.append(pkSql.substring(0, pkSql.length() - 1)).append(";");
        return sql.toString();
    }

    public static String createIndex(@NotNull String tableName, @NotNull IndexEnum indexEnum, @Nullable String indexName, @NotNull List<String> columnNames) throws Exception {
        StringBuilder sql = new StringBuilder(String.format("ALTER TABLE `%s` ", tableName));
        String indexSql = DDLGenerator.generateIndex(indexEnum, indexName, columnNames);
        sql.append(indexSql.substring(0, indexSql.length() - 1)).append(";");
        return sql.toString();
    }

    public static String deleteIndex(@NotNull String tableName, @NotNull String indexName) throws Exception {
        return String.format("ALTER TABLE `%s` ", tableName) + String.format("DROP INDEX `%s`;", indexName);
    }

    public static String deleteIndex(@NotNull String tableName, @NotNull List<String> columnNames) throws Exception {
        return DDLGenerator.deleteIndex(tableName, DDLGenerator.getIndexName(columnNames));
    }

    static String generateFiledSql(Field filed) {
        StringBuilder sql = new StringBuilder();
        sql.append("`").append(filed.getColumnName()).append("` ");
        sql.append(DDLGenerator.generateDataType(filed));
        if (filed.nullable().booleanValue()) {
            sql.append("NULL ");
        } else {
            sql.append("NOT NULL ");
        }
        if (filed.getAutoIncrement().booleanValue()) {
            sql.append("AUTO_INCREMENT ");
        }
        sql.append(DDLGenerator.generateDefaultValue(filed));
        String comment = filed.getComment();
        if (Objects.nonNull(comment)) {
            sql.append(String.format("COMMENT '%s' ", comment));
        }
        return sql.append(",").toString();
    }

    static String generateDataType(Field filed) {
        DataTypeEnum dataType = filed.getDataType();
        String type = dataType.getType();
        String name = dataType.getName();
        Integer size = filed.getSize();
        if (Objects.isNull(size)) {
            size = dataType.getDefaultSize();
        }
        if ("TIME".equals(type)) {
            return name + " ";
        }
        if ("REAL".equals(type)) {
            Integer scale = filed.getScale();
            if (Objects.isNull(scale)) {
                scale = dataType.getDefaultScale();
            }
            return String.format("%s(%s,%s) ", name, size, scale);
        }
        return String.format("%s(%s) ", name, size);
    }

    static String generateDefaultValue(Field filed) {
        String defaultValue = filed.getDefaultValue();
        if (Objects.nonNull(defaultValue)) {
            DataTypeEnum dataType;
            String expr = "DEFAULT '%s' ";
            if (filed.getDefaultValueIsExpr().booleanValue()) {
                expr = "DEFAULT %s ";
            }
            if (DataTypeEnum.BIT == (dataType = filed.getDataType())) {
                expr = "DEFAULT b'%s' ";
            }
            return String.format(expr, defaultValue);
        }
        return "";
    }

    static String generatePK(@NotNull List<String> primaryKeys, boolean isAdd) {
        String expr = "PRIMARY KEY (";
        if (isAdd) {
            expr = "ADD PRIMARY KEY (";
        }
        StringBuilder sql = new StringBuilder(expr);
        for (String pk : primaryKeys) {
            sql.append("`").append(pk).append("`,");
        }
        return sql.substring(0, sql.length() - 1) + "),";
    }

    static String generateIndex(@NotNull IndexEnum index, @Nullable String indexName, @NotNull List<String> columnNames) {
        String idxName;
        String expr = "ADD INDEX `%s` (";
        if (IndexEnum.UNIQUE_INDEX == index) {
            expr = "ADD UNIQUE INDEX `%s` (";
        }
        if (null == (idxName = indexName) || idxName.trim().isEmpty()) {
            idxName = DDLGenerator.getIndexName(columnNames);
        }
        StringBuilder sql = new StringBuilder(String.format(expr, idxName));
        for (String name : columnNames) {
            sql.append("`").append(name).append("`,");
        }
        return sql.substring(0, sql.length() - 1) + "),";
    }

    static String getIndexName(@NotNull List<String> columnNames) {
        StringBuilder indexName = new StringBuilder();
        for (String column : columnNames) {
            indexName.append(column).append("_");
        }
        return indexName.substring(0, indexName.length() - 1);
    }
}

