/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata.repository;

import com.digiwin.app.metadata.DWMetadata;
import com.digiwin.app.metadata.DWMetadataRepository;
import com.digiwin.app.metadata.exceptions.DWMetadataException;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.dbutils.QueryRunner;
import org.springframework.util.StringUtils;

public class DWMetadataLocalRepository
implements DWMetadataRepository {
    private String queryRunnerName;
    private LoadingCache<String, DWMetadata<?>> metadataCache;

    public DWMetadataLocalRepository() {
        this(null);
    }

    public DWMetadataLocalRepository(String queryRunnerName) {
        this(queryRunnerName, DEFAULT_MAX_CACHE_SIZE);
    }

    public DWMetadataLocalRepository(String queryRunnerName, int maxCacheSize) {
        this.queryRunnerName = queryRunnerName;
        this.metadataCache = CacheBuilder.newBuilder().expireAfterAccess((long)DEFAULT_EXPIRE_TIME.intValue(), TimeUnit.HOURS).initialCapacity(DEFAULT_INIT_CACHE_SIZE.intValue()).maximumSize(maxCacheSize > DEFAULT_INIT_CACHE_SIZE ? (long)maxCacheSize : (long)DEFAULT_INIT_CACHE_SIZE.intValue()).build(new CacheLoader<String, DWMetadata<?>>(this){

            public DWMetadata<?> load(String key) throws Exception {
                return null;
            }
        });
    }

    public boolean doHas(String key) {
        return !Objects.isNull(this.doGet(key));
    }

    public <T extends DWMetadata<?>> T doGet(String key) {
        return (T)((DWMetadata)this.metadataCache.getIfPresent((Object)key));
    }

    public void doAdd(String key, DWMetadata<?> metadata) {
        this.metadataCache.put((Object)key, metadata);
    }

    public void doRemove(String key) {
        this.metadataCache.invalidate((Object)key);
    }

    public String buildCacheKey(String name) {
        String queryRunnerName = this.getQueryRunnerName();
        if (!SpringContextUtils.containsBean((String)queryRunnerName)) {
            throw new DWMetadataException("'QueryRunner' instance not found from spring context.");
        }
        QueryRunner queryRunner = (QueryRunner)SpringContextUtils.getBean((String)queryRunnerName);
        try (Connection conn = queryRunner.getDataSource().getConnection();){
            String url = conn.getMetaData().getURL();
            if (StringUtils.hasText((String)url)) {
                name = String.join((CharSequence)"@", this.parseUrl(url), name);
            }
        }
        catch (SQLException e) {
            throw new DWMetadataException("Get datasource url error.", (Throwable)e);
        }
        return name;
    }

    public String getQueryRunnerName() {
        if (StringUtils.hasText((String)this.queryRunnerName)) {
            return this.queryRunnerName;
        }
        return super.getQueryRunnerName();
    }

    public void setQueryRunnerName(String queryRunnerName) {
        this.queryRunnerName = queryRunnerName;
    }
}

