/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.ddl.util;

import com.digiwin.app.ddl.model.Field;
import com.digiwin.app.ddl.model.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class MetadataSqlGenerator {
    static final String INSERT_TABLE = "INSERT INTO `dw_rdbms_tables` (`table_name`, `table_display_name`, `table_description`, `delete_constraint`, `hint_field`) VALUES ('%s', '%s', '%s', 'N', NULL);";
    static final String INSERT_FIELD = "INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ";
    static final String INSERT_FIELD_VALUE = "('%s', %s, '%s', '%s', '%s', 'N', '%s', '%s', '%s', '%s', 'N', '%s', '%s'),";
    static final String DELETE_TABLE = "DELETE FROM `dw_rdbms_tables` WHERE `table_name` = '%s';";
    static final String DELETE_FIELDS_BY_TABLE = "DELETE FROM `dw_rdbms_fields` WHERE `TABLE_NAME` = '%s';";
    static final String UPDATE_FIELD = "UPDATE `dw_rdbms_fields` SET `IS_KEY`='%s', `FIELD_TYPE`='%s', `SCALE`='%s', `DEFAULT_VALUE`='%s', `NULLABLE`='%s', `SIZE`='%s', `IS_AUTO_INCREMENT`='%s' WHERE `TABLE_NAME`='%s' AND `FIELD_NAME`='%s';";
    static final String UPDATE_FIELD_IS_PK = "UPDATE `dw_rdbms_fields` SET `IS_KEY`='Y' WHERE `TABLE_NAME`='%s' AND `FIELD_NAME`='%s';";
    static final String DELETE_FIELD = "DELETE FROM `dw_rdbms_fields` WHERE `TABLE_NAME` = '%s' AND `FIELD_NAME` = '%s';";
    static final String SELECT_PRIMARY_KEY = "SELECT `FIELD_NAME` pk FROM `dw_rdbms_fields` WHERE `TABLE_NAME` = '%s' AND `IS_KEY` = 'Y' ORDER BY `SEQ`;";
    static final String SELECT_NEXT_SEQ = "SELECT (MAX(`SEQ`) + 1) seq FROM `dw_rdbms_fields` WHERE `TABLE_NAME` = '%s'";

    MetadataSqlGenerator() {
    }

    public static List<String> deleteTable(String tableName) {
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(String.format(DELETE_FIELDS_BY_TABLE, tableName));
        sqlList.add(String.format(DELETE_TABLE, tableName));
        return sqlList;
    }

    public static List<String> createTable(Table table) {
        ArrayList<String> sqlList = new ArrayList<String>();
        String tableName = table.getTableName();
        String comment = table.getComment();
        sqlList.add(String.format(INSERT_TABLE, tableName, tableName, Objects.isNull(comment) ? "" : comment));
        sqlList.add(MetadataSqlGenerator.insertFields(tableName, table.getFields(), 1));
        return sqlList;
    }

    public static String insertFields(String tableName, List<Field> fields, int beginSeq) {
        StringBuilder sql = new StringBuilder();
        sql.append(INSERT_FIELD);
        for (Field field : fields) {
            sql.append(MetadataSqlGenerator.insertFieldValue(tableName, field, beginSeq++));
        }
        return String.valueOf(sql.deleteCharAt(sql.length() - 1)) + ";";
    }

    public static List<String> updateFields(String tableName, List<Field> fields) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (Field field : fields) {
            sqlList.add(MetadataSqlGenerator.updateField(tableName, field));
        }
        return sqlList;
    }

    public static List<String> setColumnIsPrimaryKey(String tableName, List<String> columnNames) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (String columnName : columnNames) {
            sqlList.add(String.format(UPDATE_FIELD_IS_PK, tableName, columnName));
        }
        return sqlList;
    }

    public static List<String> deleteFields(String tableName, List<String> columnNames) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (String columnName : columnNames) {
            sqlList.add(String.format(DELETE_FIELD, tableName, columnName));
        }
        return sqlList;
    }

    public static String getPrimaryKey(String tableName) {
        return String.format(SELECT_PRIMARY_KEY, tableName);
    }

    public static String getNextSeq(String tableName) {
        return String.format(SELECT_NEXT_SEQ, tableName);
    }

    static String insertFieldValue(String tableName, Field field, int seq) {
        String columnName = field.getColumnName();
        String isPK = field.isPK() != false ? "Y" : "N";
        String dataType = field.getDataType().getName();
        String scale = "";
        if (Objects.nonNull(field.getScale())) {
            scale = field.getScale().toString();
        } else if (Objects.nonNull(field.getDataType().getDefaultScale())) {
            scale = field.getDataType().getDefaultScale().toString();
        }
        String defaultValue = Objects.isNull(field.getDefaultValue()) ? "" : field.getDefaultValue();
        String nullable = field.nullable() != false ? "Y" : "N";
        String size = "";
        if (Objects.nonNull(field.getSize())) {
            size = field.getSize().toString();
        } else if (Objects.nonNull(field.getDataType().getDefaultSize())) {
            size = field.getDataType().getDefaultSize().toString();
        }
        String autoIncrement = field.getAutoIncrement() != false ? "Y" : "N";
        return String.format(INSERT_FIELD_VALUE, tableName, seq, columnName, isPK, dataType, columnName, scale, defaultValue, nullable, size, autoIncrement);
    }

    static String updateField(String tableName, Field field) {
        String columnName = field.getColumnName();
        String isPK = field.isPK() != false ? "Y" : "N";
        String dataType = field.getDataType().getName();
        String scale = "";
        if (Objects.nonNull(field.getScale())) {
            scale = field.getScale().toString();
        } else if (Objects.nonNull(field.getDataType().getDefaultScale())) {
            scale = field.getDataType().getDefaultScale().toString();
        }
        String defaultValue = Objects.isNull(field.getDefaultValue()) ? "" : field.getDefaultValue();
        String nullable = field.nullable() != false ? "Y" : "N";
        String size = "";
        if (Objects.nonNull(field.getSize())) {
            size = field.getSize().toString();
        } else if (Objects.nonNull(field.getDataType().getDefaultSize())) {
            size = field.getDataType().getDefaultSize().toString();
        }
        String autoIncrement = field.getAutoIncrement() != false ? "Y" : "N";
        return String.format(UPDATE_FIELD, isPK, dataType, scale, defaultValue, nullable, size, autoIncrement, tableName, columnName);
    }
}

