/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata.loader;

import com.digiwin.app.metadata.DWAttribute;
import com.digiwin.app.metadata.DWField;
import com.digiwin.app.metadata.DWMetadata;
import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.DWValueAttribute;
import com.digiwin.app.metadata.exceptions.DWMetadataException;
import com.digiwin.app.metadata.exceptions.DWMetadataNotFoundException;
import com.digiwin.app.metadata.loader.DWMetadataLoader;
import com.digiwin.app.metadata.loader.DWMetadataLoaderManager;
import com.digiwin.app.metadata.rdbms.DWRdbmsAttributes;
import com.digiwin.app.metadata.rdbms.DWRdbmsField;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.metadata.rdbms.DWRdbmsRelationType;
import com.digiwin.app.metadata.rdbms.DWRdbmsRelationshipAttribute;
import com.digiwin.app.metadata.rdbms.DWRdbmsUtils;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;

public class DWRdbMetadataLoader
extends DWMetadataLoader<DWRdbmsMetadata> {
    private static final String FIELD_METADATA_TABLE_NAME = "TABLE_NAME";
    private static final String FIELD_METADATA_FIELD_NAME = "FIELD_NAME";
    private static final String FIELD_METADATA_FIELD_TYPE = "FIELD_TYPE";
    private static final String FIELD_METADATA_IS_KEY = "IS_KEY";
    private static final String FIELD_METADATA_NULLABLE = "NULLABLE";
    private static final String FIELD_METADATA_SIZE = "SIZE";
    private static final String FIELD_METADATA_SCALE = "SCALE";
    private static final String FIELD_METADATA_IS_VERSION = "IS_VERSION";
    private static final String FIELD_METADATA_IS_AUTO_INCREMENT = "IS_AUTO_INCREMENT";
    private static final String FIELD_METADATA_DEFAULT_VALUE = "DEFAULT_VALUE";

    public DWRdbMetadataLoader() {
        DWMetadataLoaderManager.registerLoader((DWMetadataLoader)this);
    }

    private static List<Map<String, Object>> select(String statement, Object ... params) throws DWMetadataException {
        List result;
        QueryRunner queryRunner = (QueryRunner)SpringContextUtils.getBean((String)"dw-queryRunner");
        try {
            result = (List)queryRunner.query(statement, (ResultSetHandler)new MapListHandler(), params);
        }
        catch (Exception e) {
            throw new DWMetadataException("load failed!", (Throwable)e);
        }
        return result;
    }

    private static List<Map<String, Object>> getTableStructure(String tableNo) {
        String structureSql = "SELECT * FROM dw_rdbms_fields WHERE 1=1 AND TABLE_NAME= ?";
        return DWRdbMetadataLoader.select(structureSql, tableNo);
    }

    private static List<Map<String, Object>> getTableRelationship(String params) {
        String relationSql = "SELECT * FROM dw_rdbms_relations WHERE 1=1 AND PRIMARY_TABLE_NO= ?  ";
        return DWRdbMetadataLoader.select(relationSql, params);
    }

    private static List<Map<String, Object>> getTableDescription(String params) {
        String sql = "SELECT * FROM dw_rdbms_tables WHERE 1=1 AND table_name= ?  ";
        return DWRdbMetadataLoader.select(sql, params);
    }

    private static DWRdbmsMetadata buildDWRelationshipAttributies(String tableNo, DWRdbmsMetadata tableMetadata) {
        List<Map<String, Object>> relationship = DWRdbMetadataLoader.getTableRelationship(tableNo);
        if (relationship == null || relationship.isEmpty()) {
            return tableMetadata;
        }
        for (Map<String, Object> relationMap : relationship) {
            DWRdbmsRelationshipAttribute oneToManyAttribute = new DWRdbmsRelationshipAttribute(tableMetadata, relationMap.get("REFERENCE_TABLE_NO").toString());
            String relationTypeString = (String)relationMap.get("Type");
            if (relationTypeString != null) {
                DWRdbmsRelationType relationType = Enum.valueOf(DWRdbmsRelationType.class, relationTypeString);
                oneToManyAttribute.setType(relationType);
            }
            oneToManyAttribute.setName(DWRdbmsRelationshipAttribute.NAME);
            String[] primaryTablePKArr = relationMap.get("PRIMARY_TABLE_PK").toString().split(",");
            String[] referenceTablePKArr = relationMap.get("REFERENCE_TABLE_PK").toString().split(",");
            if (primaryTablePKArr.length != referenceTablePKArr.length) {
                throw new DWMetadataException("PK\u6578\u91cf\u8a2d\u5b9a\u932f\u8aa4!!");
            }
            for (int i = 0; i < primaryTablePKArr.length; ++i) {
                oneToManyAttribute.addJoinColumn(primaryTablePKArr[i], referenceTablePKArr[i]);
            }
            tableMetadata.addAttribute(new DWAttribute[]{oneToManyAttribute});
        }
        return tableMetadata;
    }

    private static boolean parseStringValueToBoolean(String key, Map<String, Object> valueMap) {
        boolean result = false;
        String value = (String)valueMap.get(key);
        if ("Y".equalsIgnoreCase(value)) {
            result = true;
        }
        return result;
    }

    private static int parseStringValueToInt(String key, Map<String, Object> valueMap) {
        String value = (String)valueMap.get(key);
        if (value == null || value.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public static DWRdbmsField[] generateDWRdbmsField(List<Map<String, Object>> tableStructure) {
        DWRdbmsField[] structureFiled = new DWRdbmsField[tableStructure.size()];
        int index = 0;
        for (Map<String, Object> map : tableStructure) {
            String fieldType = map.get(FIELD_METADATA_FIELD_TYPE).toString().toLowerCase();
            String fieldName = map.get(FIELD_METADATA_FIELD_NAME).toString();
            boolean isKey = DWRdbMetadataLoader.parseStringValueToBoolean(FIELD_METADATA_IS_KEY, map);
            boolean nullable = DWRdbMetadataLoader.parseStringValueToBoolean(FIELD_METADATA_NULLABLE, map);
            int size = DWRdbMetadataLoader.parseStringValueToInt(FIELD_METADATA_SIZE, map);
            String defaultValue = (String)map.get(FIELD_METADATA_DEFAULT_VALUE);
            switch (fieldType) {
                case "char": 
                case "varchar": 
                case "nvarchar": 
                case "tinytext": 
                case "text": 
                case "mediumtext": 
                case "longtext": {
                    structureFiled[index] = DWRdbmsUtils.createStringField(fieldName, size, nullable, isKey, defaultValue);
                    break;
                }
                case "json": {
                    structureFiled[index] = DWRdbmsUtils.createJsonField(fieldName, size, nullable, isKey, defaultValue);
                    break;
                }
                case "number": 
                case "float": 
                case "double": 
                case "decimal": {
                    int scale = DWRdbMetadataLoader.parseStringValueToInt(FIELD_METADATA_SCALE, map);
                    if (scale > 0) {
                        structureFiled[index] = DWRdbmsUtils.createDecimalField(fieldName, size, nullable, scale, defaultValue);
                        break;
                    }
                    structureFiled[index] = DWRdbmsUtils.createIntegerField(fieldName, size, nullable, isKey, defaultValue);
                    break;
                }
                case "tinyint": 
                case "smallint": 
                case "mediumint": 
                case "int": 
                case "bigint": 
                case "bit": 
                case "time": 
                case "year": 
                case "timestamp": {
                    structureFiled[index] = DWRdbmsUtils.createIntegerField(fieldName, size, nullable, isKey, defaultValue);
                    break;
                }
                case "date": {
                    structureFiled[index] = DWRdbmsUtils.createDateField(fieldName, nullable, isKey, defaultValue);
                    break;
                }
                case "datetime": {
                    structureFiled[index] = DWRdbmsUtils.createDatetimeField(fieldName, nullable, isKey, defaultValue);
                    break;
                }
                case "binary": 
                case "varbinary": 
                case "tinyblob": 
                case "blob": 
                case "mediumblob": 
                case "longblob": {
                    structureFiled[index] = new DWRdbmsField(fieldName, fieldName, size, 0, nullable, isKey, defaultValue);
                    break;
                }
                default: {
                    throw new DWMetadataException("This field type [" + fieldType + "] is not supported!");
                }
            }
            if (DWRdbMetadataLoader.parseStringValueToBoolean(FIELD_METADATA_IS_VERSION, map)) {
                structureFiled[index].setVersionControl();
            }
            if (DWRdbMetadataLoader.parseStringValueToBoolean(FIELD_METADATA_IS_AUTO_INCREMENT, map)) {
                structureFiled[index].setAutoIncrement();
            }
            ++index;
        }
        return structureFiled;
    }

    public DWRdbmsMetadata load(String name) {
        List<Map<String, Object>> tableInfo = DWRdbMetadataLoader.getTableDescription(name);
        if (tableInfo == null || tableInfo.isEmpty()) {
            throw new DWMetadataNotFoundException(name);
        }
        DWRdbmsMetadata tableMetadata = DWRdbmsUtils.createMetadata(name);
        Map<String, Object> tableInfoMap = tableInfo.get(0);
        tableMetadata.addAttribute(new DWAttribute[]{DWValueAttribute.create((Object)(null != tableInfoMap.get("table_display_name") ? tableInfoMap.get("table_display_name") : ""), (String)DWRdbmsAttributes.RDBMS_TABLE_DISPLAYNAME)});
        tableMetadata.addAttribute(new DWAttribute[]{DWValueAttribute.create((Object)(null != tableInfoMap.get("table_description") ? tableInfoMap.get("table_description") : ""), (String)DWRdbmsAttributes.RDBMS_TABLE_DESCRIPTION)});
        tableMetadata.addAttribute(new DWAttribute[]{DWValueAttribute.create((Object)(null != tableInfoMap.get("delete_constraint") ? tableInfoMap.get("delete_constraint") : ""), (String)DWRdbmsAttributes.RDBMS_DELETECONSTRAINT)});
        tableMetadata.addAttribute(new DWAttribute[]{DWValueAttribute.create((Object)(null != tableInfoMap.get("hint_field") ? tableInfoMap.get("hint_field") : ""), (String)DWRdbmsAttributes.RDBMS_HINTFIELD)});
        tableMetadata.addAttribute(new DWAttribute[]{DWValueAttribute.create((Object)(null != tableInfoMap.get("insert_default_value") ? tableInfoMap.get("insert_default_value") : null), (String)DWRdbmsAttributes.RDBMS_INSERT_DEFAULT_VALUE)});
        tableMetadata.addAttribute(new DWAttribute[]{DWValueAttribute.create((Object)(null != tableInfoMap.get("update_default_value") ? tableInfoMap.get("update_default_value") : null), (String)DWRdbmsAttributes.RDBMS_UPDATE_DEFAULT_VALUE)});
        List<Map<String, Object>> tableStructure = DWRdbMetadataLoader.getTableStructure(name);
        if (tableStructure == null || tableStructure.isEmpty()) {
            throw new DWMetadataException("The table[" + name + "] has no any fields description in the dw_rdbms_fields!");
        }
        DWRdbmsField[] structureFiled = DWRdbMetadataLoader.generateDWRdbmsField(tableStructure);
        for (int i = 0; i < structureFiled.length; ++i) {
            tableMetadata.addField((DWField)structureFiled[i]);
        }
        DWMetadataContainer.add((DWMetadata)tableMetadata);
        tableMetadata = DWRdbMetadataLoader.buildDWRelationshipAttributies(name, tableMetadata);
        return tableMetadata;
    }

    public List<String> getTableNames() {
        List<Map<String, Object>> tableNameList = DWRdbMetadataLoader.select("select table_name from dw_rdbms_tables", new Object[0]);
        return tableNameList.stream().map(r -> (String)r.get("table_name")).collect(Collectors.toList());
    }
}

