/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.data.service;

import com.dap.component.data.permission.api.DataPermissionRequestContextProvider;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.data.DWDataPermissionOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.data.permission.DWRowPermissionElement;
import com.digiwin.data.permission.DWRowPermissionElementDeserializer;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DWDataPermission {
    public static final String IAM_DATAPERMISSION_API2 = "/api/iam/v2/permission/data";
    public static final String IAM_DATAPERMISSION_API_BY_API = "/api/iam/v2/permission/data/tempuser";
    public static final String OPTION_MODULE_ID = "moduleId";
    public static final String OPTION_ACTION_ID = "actionId";
    public static final String OPTION_API = "api";
    private static String appId = SpringContextUtils.getEnvironment().getProperty("appId");
    private static Gson customGson = null;

    public static String getAppId() {
        if (null == appId || appId.trim().isEmpty()) {
            throw new DWRuntimeException("DWDataPermission.appId is not ready, please contact DAP for this issue.");
        }
        return appId;
    }

    private static synchronized Gson getCustomGson() {
        if (customGson == null) {
            GsonBuilder builder = new GsonBuilder().serializeNulls();
            builder.registerTypeAdapter(DWRowPermissionElement.class, (Object)new DWRowPermissionElementDeserializer());
            customGson = builder.create();
        }
        return customGson;
    }

    public static Object getDataPermission(String moduleId, String actionId) throws Exception {
        DataPermissionRequestContextProvider requestContextProvider = (DataPermissionRequestContextProvider)SpringContextUtils.getBean((String)"dataPermissionRequestContextProvider");
        Map profile = requestContextProvider.getProfile();
        Object userId = profile.get("userId");
        String userToken = requestContextProvider.getToken();
        String appId = DWDataPermission.getAppId();
        HashMap params = new HashMap();
        params.put("userId", userId);
        params.put("sysId", appId);
        params.put(OPTION_MODULE_ID, moduleId);
        params.put(OPTION_ACTION_ID, actionId);
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL(IAM_DATAPERMISSION_API2);
        serviceModel.setParams(params);
        serviceModel.setToken(userToken);
        HttpResponseModel iamResponseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)serviceModel);
        String iamResponseBody = iamResponseModel.getResponseBody();
        int iamResponseStatusCode = iamResponseModel.getHttpStatusCode();
        if (iamResponseStatusCode != 200) {
            String errorMessage = "IAM\u56de\u50b3\u72c0\u614b\u78bc\u70ba:%s, \u932f\u8aa4\u8a0a\u606f\u70ba:%s";
            throw new DWException(String.format(errorMessage, iamResponseStatusCode, errorMessage));
        }
        Gson gson = DWDataPermission.getCustomGson();
        return gson.fromJson(iamResponseBody, DWUserPermission.class);
    }

    public static Object getDataPermission(String api) throws Exception {
        DWUserPermission result = null;
        DataPermissionRequestContextProvider requestContextProvider = (DataPermissionRequestContextProvider)SpringContextUtils.getBean((String)"dataPermissionRequestContextProvider");
        String userToken = requestContextProvider.getToken();
        HashMap params = new HashMap();
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL(IAM_DATAPERMISSION_API_BY_API);
        serviceModel.setParams(params);
        serviceModel.setToken(userToken);
        HttpResponseModel iamResponseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)serviceModel);
        String iamResponseBody = iamResponseModel.getResponseBody();
        int iamResponseStatusCode = iamResponseModel.getHttpStatusCode();
        if (iamResponseStatusCode != 200) {
            String errorMessage = "IAM\u56de\u50b3\u72c0\u614b\u78bc\u70ba:%s, \u932f\u8aa4\u8a0a\u606f\u70ba:%s";
            throw new DWException(String.format(errorMessage, iamResponseStatusCode, errorMessage));
        }
        Gson gson = DWDataPermission.getCustomGson();
        List dataPerms = (List)gson.fromJson(iamResponseBody, List.class);
        for (Map dataPerm : dataPerms) {
            String dataPermApi = String.valueOf(dataPerm.get(OPTION_API));
            if (!dataPermApi.equals(api)) continue;
            String dataPermRowPermissionStr = String.valueOf(dataPerm.get("rowPermission"));
            Map dataPermRowPermission = (Map)gson.fromJson(dataPermRowPermissionStr, Map.class);
            String dataPermColPermissionStr = String.valueOf(dataPerm.get("colPermission"));
            List dataPermColPermission = (List)gson.fromJson(dataPermColPermissionStr, List.class);
            HashMap<String, Object> dwUserPermissionMap = new HashMap<String, Object>();
            dwUserPermissionMap.put("superadmin", false);
            dwUserPermissionMap.put("rowPermission", dataPermRowPermission);
            dwUserPermissionMap.put("colPermission", dataPermColPermission);
            String gsonPermissionMap = gson.toJson(dwUserPermissionMap);
            result = (DWUserPermission)gson.fromJson(gsonPermissionMap, DWUserPermission.class);
            break;
        }
        return result;
    }

    public static DWUserPermission getDataPermission(IDWSQLOptions options) throws Exception {
        DWUserPermission result = null;
        String api = null;
        String moduleId = null;
        String actionId = null;
        if (options instanceof DWDataPermissionOption) {
            DWDataPermissionOption dataPermOption = (DWDataPermissionOption)options;
            api = dataPermOption.getApi();
            moduleId = dataPermOption.getModuleId();
            actionId = dataPermOption.getActionId();
        } else {
            DataPermissionRequestContextProvider requestContextProvider = (DataPermissionRequestContextProvider)SpringContextUtils.getBean((String)"dataPermissionRequestContextProvider");
            Map requestHeader = requestContextProvider.getRequestHeader();
            if (requestHeader.containsKey(OPTION_MODULE_ID)) {
                moduleId = requestHeader.get(OPTION_MODULE_ID).toString();
            }
            if (requestHeader.containsKey(OPTION_ACTION_ID)) {
                actionId = requestHeader.get(OPTION_ACTION_ID).toString();
            }
            if (requestContextProvider.getAllowCrossTenant()) {
                api = requestContextProvider.getRequestURI();
            }
        }
        if (api != null) {
            if (api.startsWith("/")) {
                api = api.substring(1);
            }
            result = (DWUserPermission)DWDataPermission.getDataPermission(api);
        } else if (actionId != null && moduleId != null) {
            result = (DWUserPermission)DWDataPermission.getDataPermission(moduleId, actionId);
        }
        return result;
    }
}

