/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.filter;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.filter.IDWSQLFilter;
import com.digiwin.app.data.DWDataPermissionOption;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.data.permission.DWRowPermissionDefaultMatchOption;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.data.service.DWDataPermission;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWDataPermissionSQLFilter
implements IDWSQLFilter {
    private static Log log = LogFactory.getLog(DWDataPermissionSQLFilter.class);
    public static final String TAG_DATA_PERM = "${dataPerm}";
    private static final String MATCH_QUOTE_EMPTY = Matcher.quoteReplacement(" ");

    public void doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options) {
        String sqlcommand = sqlInfo.getSql();
        List parameters = sqlInfo.getParametersAsList();
        if (sqlcommand.contains(TAG_DATA_PERM)) {
            log.debug((Object)("[DWDataPermissionSQLFilter.doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options)],before sql command:" + sqlcommand));
            DWUserPermission dataPermData = null;
            try {
                dataPermData = DWDataPermission.getDataPermission(options);
                if (dataPermData != null && options instanceof DWDataPermissionOption) {
                    DWDataPermissionOption dataPermOption = (DWDataPermissionOption)options;
                    dataPermOption.setColumnPermission(dataPermData.getColumnPermission());
                }
            }
            catch (Exception e) {
                log.error((Object)("[DWDataPermissionSQLFilter.doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options)], exception message=" + e.getMessage()));
            }
            if (dataPermData != null) {
                String rowPermissionSql;
                DWRowPermissionMatchOption rowPermissionOption = new DWRowPermissionDefaultMatchOption();
                if (options instanceof DWDataPermissionOption) {
                    rowPermissionOption = ((DWDataPermissionOption)options).getRowPermissionOption();
                }
                sqlcommand = (rowPermissionSql = dataPermData.getRowPermission().getSQLContainValues(rowPermissionOption)) != null && !rowPermissionSql.isEmpty() ? sqlcommand.replaceAll(Pattern.quote(TAG_DATA_PERM), Matcher.quoteReplacement(" and " + rowPermissionSql)) : sqlcommand.replaceAll(Pattern.quote(TAG_DATA_PERM), MATCH_QUOTE_EMPTY);
            } else {
                sqlcommand = sqlcommand.replaceAll(Pattern.quote(TAG_DATA_PERM), MATCH_QUOTE_EMPTY);
            }
            log.debug((Object)("[DWDataPermissionSQLFilter.doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options)],after sql command:" + sqlcommand));
            sqlInfo.setSqlAndParameters(sqlcommand, parameters);
        }
    }

    public void doFilter(DWQueryInfo queryInfo, IDWSQLOptions options) {
        DWUserPermission dataPermData = null;
        try {
            dataPermData = DWDataPermission.getDataPermission(options);
        }
        catch (Exception e) {
            log.error((Object)("[DWDataPermissionSQLFilter.doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options)], e=" + e.getMessage()));
        }
        if (dataPermData != null) {
            DWQueryCondition queryCondition;
            DWRowPermissionMatchOption rowPermissionOption = new DWRowPermissionDefaultMatchOption();
            if (options instanceof DWDataPermissionOption) {
                rowPermissionOption = ((DWDataPermissionOption)options).getRowPermissionOption();
            }
            if ((queryCondition = dataPermData.getRowPermission().getQueryCondition(rowPermissionOption)).size() > 0) {
                DWQueryCondition fixedCondition = queryInfo.getFixedCondition();
                fixedCondition.addCondition(queryCondition);
            }
        }
    }

    public void doFilter(DWDataRow dataRow, IDWSQLOptions options) {
    }
}

