/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.data.permission;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.data.permission.DWPermissionCondition;
import com.digiwin.data.permission.DWPermissionConditionSingleValueBase;
import com.digiwin.data.permission.DWPermissionEqualsCondition;
import com.digiwin.data.permission.DWPermissionInCondition;
import com.digiwin.data.permission.DWPermissionNotInCondition;
import com.digiwin.data.permission.DWPermissionOperator;
import com.digiwin.data.permission.DWRowPermissionDefaultMatchOption;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import com.digiwin.data.permission.row.condition.DWPermissionBetweenCondition;
import com.digiwin.data.permission.row.condition.DWPermissionGreaterThanOrEqualToCondition;
import com.digiwin.data.permission.row.condition.DWPermissionIsNotNullCondition;
import com.digiwin.data.permission.row.condition.DWPermissionIsNullCondition;
import com.digiwin.data.permission.row.condition.DWPermissionLessThanOrEqualToCondition;
import com.digiwin.data.permission.row.condition.DWPermissionLikeCondition;
import com.digiwin.data.permission.row.condition.DWPermissionNotEqualsCondition;
import com.digiwin.data.permission.row.condition.DWPermissionNotLikeCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class DWPermissionOperatorProcessor {
    private static List<DWPermissionCondition> conditions = new ArrayList<DWPermissionCondition>();

    public static boolean execute(Object data, String operatorStr, List<? extends Object> conditionValues) {
        DWPermissionOperator op = DWPermissionOperator.valueOfIgnoreCase(operatorStr);
        return DWPermissionOperatorProcessor.execute(data, op, conditionValues);
    }

    public static boolean execute(Object data, DWPermissionOperator operator, List<? extends Object> conditionValues) {
        return DWPermissionOperatorProcessor.get(operator).isMatch(data, operator, conditionValues);
    }

    public static boolean execute(Object data, String operatorStr, Object conditionValues) {
        DWPermissionOperator op = DWPermissionOperator.valueOfIgnoreCase(operatorStr);
        return DWPermissionOperatorProcessor.execute(data, op, conditionValues);
    }

    public static boolean execute(Object data, DWPermissionOperator operator, Object conditionValue) {
        return ((DWPermissionConditionSingleValueBase)DWPermissionOperatorProcessor.get(operator)).matchCoreSingleValue(data, operator, conditionValue);
    }

    public static DWPermissionCondition get(DWPermissionOperator operator) {
        DWPermissionCondition condition;
        Optional<DWPermissionCondition> result = conditions.stream().filter(c -> c.isSupport(operator)).findFirst();
        DWPermissionCondition dWPermissionCondition = condition = result.isPresent() ? result.get() : null;
        if (condition == null) {
            throw new UnsupportedOperationException((Object)((Object)operator) + " has no any condition implementation!");
        }
        return condition;
    }

    public static DWSqlInfo getSQL(String fieldName, String operatorStr, List<? extends Object> conditionValues, DWRowPermissionMatchOption option) {
        DWPermissionOperator op = DWPermissionOperator.valueOfIgnoreCase(operatorStr);
        return DWPermissionOperatorProcessor.getSQL(fieldName, op, conditionValues, option);
    }

    public static DWSqlInfo getSQL(String fieldName, DWPermissionOperator operator, List<? extends Object> conditionValues, DWRowPermissionMatchOption option) {
        if (option == null) {
            option = new DWRowPermissionDefaultMatchOption();
        }
        DWPermissionCondition condition = DWPermissionOperatorProcessor.get(operator);
        return condition.getSQL(fieldName, operator, conditionValues, option);
    }

    public static String getSQLContainValues(String fieldName, String operatorStr, List<? extends Object> conditionValues, DWRowPermissionMatchOption option) {
        DWPermissionOperator op = DWPermissionOperator.valueOfIgnoreCase(operatorStr);
        return DWPermissionOperatorProcessor.getSQLContainValues(fieldName, op, conditionValues, option);
    }

    public static String getSQLContainValues(String fieldName, DWPermissionOperator operator, List<? extends Object> conditionValues, DWRowPermissionMatchOption option) {
        if (option == null) {
            option = new DWRowPermissionDefaultMatchOption();
        }
        DWPermissionCondition condition = DWPermissionOperatorProcessor.get(operator);
        return condition.getSQLContainValues(fieldName, operator, conditionValues, option);
    }

    public static DWQueryCondition getQueryInfo(String fieldName, String operatorStr, List<? extends Object> conditionValues, DWRowPermissionMatchOption option) {
        DWPermissionOperator op = DWPermissionOperator.valueOfIgnoreCase(operatorStr);
        return DWPermissionOperatorProcessor.getQueryInfo(fieldName, op, conditionValues, option);
    }

    public static DWQueryCondition getQueryInfo(String fieldName, DWPermissionOperator operator, List<? extends Object> conditionValues, DWRowPermissionMatchOption option) {
        if (option == null) {
            option = new DWRowPermissionDefaultMatchOption();
        }
        DWPermissionCondition condition = DWPermissionOperatorProcessor.get(operator);
        return condition.getQueryCondition(fieldName, operator, conditionValues, option);
    }

    static {
        conditions.add(new DWPermissionEqualsCondition());
        conditions.add(new DWPermissionInCondition());
        conditions.add(new DWPermissionNotInCondition());
        conditions.add(new DWPermissionBetweenCondition());
        conditions.add(new DWPermissionGreaterThanOrEqualToCondition());
        conditions.add(new DWPermissionIsNotNullCondition());
        conditions.add(new DWPermissionIsNullCondition());
        conditions.add(new DWPermissionLessThanOrEqualToCondition());
        conditions.add(new DWPermissionLikeCondition());
        conditions.add(new DWPermissionNotEqualsCondition());
        conditions.add(new DWPermissionNotLikeCondition());
    }
}

