/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.util;

import com.dap.component.documentid.api.DapDocumentIdFinder;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWPaginationQueryResult;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.util.DocumentIdSetting;
import org.apache.commons.lang3.StringUtils;

public class DocumentIdFinder
implements DapDocumentIdFinder {
    @Override
    public String getMaxSerialNo(String group, DocumentIdSetting setting) throws Exception {
        DWDao targetDao;
        String serialPrefix = setting.getSerialPrefix();
        if (StringUtils.isNotBlank((CharSequence)serialPrefix)) {
            group = (String)group + serialPrefix;
        }
        String documentId = null;
        DWPagableQueryInfo queryInfo = new DWPagableQueryInfo();
        queryInfo.setSelectFields(new String[]{setting.getColumnName()});
        queryInfo.setTableName(setting.getTableName());
        if (setting.isAccurateRuleMatchEnable()) {
            queryInfo.addFieldInfo(setting.getColumnName(), DWQueryValueOperator.Like, new Object[]{(String)group + "%%" + setting.getSuffix()});
            queryInfo.addFieldInfo(setting.getColumnName(), DWQueryValueOperator.REGEXP, new Object[]{"^" + this.escapeExprSpecialWord((String)group) + "[0-9]{" + setting.getSerialIdLength() + "}" + this.escapeExprSpecialWord(setting.getSuffix()) + "$"});
        } else {
            queryInfo.addFieldInfo(setting.getColumnName(), DWQueryValueOperator.Like, new Object[]{(String)group + "%%" + setting.getSuffix()});
        }
        if (setting.getConditions() != null) {
            setting.getConditions().forEach((key, value) -> queryInfo.addFieldInfo(key, DWQueryValueOperator.Equals, new Object[]{value}));
        }
        queryInfo.addOrderBy(setting.getColumnName(), false);
        queryInfo.setPageSize(1);
        queryInfo.setPageNumber(1);
        DWDao dWDao = targetDao = setting.getDao() == null ? this.getDefaultDao() : setting.getDao();
        if (targetDao == null) {
            throw new DWException("Dao not found, Please check the dao bean or setting.setDao");
        }
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(setting.isTenant());
        DWPaginationQueryResult data = targetDao.selectWithPage(queryInfo, option);
        if (data.getDataSet().getTable(setting.getTableName()).getRows().size() != 0) {
            documentId = (String)data.getDataSet().getTable(setting.getTableName()).getRow(0).get(setting.getColumnName());
        }
        return documentId;
    }

    private DWDao getDefaultDao() {
        DWDao defaultDao = null;
        try {
            defaultDao = (DWDao)SpringContextUtils.getBean((String)"dw-dao");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultDao;
    }

    public String escapeExprSpecialWord(String keyword) {
        String[] specialWords;
        for (String key : specialWords = new String[]{"\\", "$", "(", ")", "*", "+", ".", "[", "]", "?", "^", "{", "}", "|"}) {
            if (!keyword.contains(key)) continue;
            keyword = keyword.replace(key, "\\" + key);
        }
        return keyword;
    }
}

