/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client;

import com.digiwin.http.client.DWHttpRetryBackoff;

public class DWHttpRetryArithmeticSequenceBackoff
implements DWHttpRetryBackoff {
    private long firstBackoff = 2000L;
    private long maxBackoff = 60000L;
    private int commonDifference = 2000;

    public DWHttpRetryArithmeticSequenceBackoff() {
    }

    public DWHttpRetryArithmeticSequenceBackoff(long firstBackoff, long maxBackoff, int commonDifference) {
        this.firstBackoff = firstBackoff;
        this.maxBackoff = maxBackoff;
        this.commonDifference = commonDifference;
    }

    @Override
    public long calculate(int executionCount, long previousBackoff) {
        long backoff = executionCount == 1 ? this.firstBackoff : this.firstBackoff + (long)(this.commonDifference * (executionCount - 1));
        if (backoff > this.maxBackoff) {
            backoff = this.maxBackoff;
        }
        if (backoff < 0L) {
            return 0L;
        }
        return backoff;
    }
}

