/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.utils;

import com.dap.component.httpclient.api.HttpClientRequestContextProvider;
import com.dap.component.httpclient.api.HttpClientResourceBundleProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.http.client.DWHttpClientProperties;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequest;

public final class DWRequestHeaderUtils {
    public static final String HEADER_STANDARD_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HEADER_DAP_API_TOKEN = "token";
    public static final String PROPERTY_IAM_AP_TOKEN = "iamApToken";
    public static final String PROPERTY_IAM_AP_SECRET = "iamApSecret";
    public static final String PROPERTY_SERVER_HTTP_TOKEN_MODE = "serverHttpTokenmode";
    public static final String SERVER_HTTP_TOKEN_MODE_IAM = "IAM";
    public static final String HEADER_IAM_API_USER_TOKEN = "digi-middleware-auth-user";
    public static final String HEADER_IAM_API_APP_TOKEN = "digi-middleware-auth-app";
    public static final String HEADER_IAM_API_APP_SECRET = "digi-middleware-auth-app-secret";

    public static Map<String, String> getDapApiRequiredHeaders() {
        HttpClientResourceBundleProvider resourceBundleProvider;
        Locale locale;
        HashMap<String, String> requiredHeaders = new HashMap<String, String>();
        HttpClientRequestContextProvider requestContextProvider = (HttpClientRequestContextProvider)SpringContextUtils.getBean((String)"httpClientRequestContextProvider");
        String token = requestContextProvider.getToken();
        if (token != null && !token.isEmpty()) {
            requiredHeaders.put(HEADER_DAP_API_TOKEN, token);
        }
        if ((locale = (resourceBundleProvider = (HttpClientResourceBundleProvider)SpringContextUtils.getBean((String)"httpClientResourceBundleProvider")).getCurrentLocale()) != null) {
            requiredHeaders.put(HEADER_STANDARD_ACCEPT_LANGUAGE, locale.toLanguageTag());
        }
        return requiredHeaders;
    }

    public static void attachAppAuthInfo(String appId, HttpRequest request) {
        String apSecret;
        String apToken;
        if (!(request.containsHeader(HEADER_IAM_API_APP_TOKEN) || (apToken = DWHttpClientProperties.getProperties().getIamApToken()) == null || apToken.isEmpty() || DWHttpClientProperties.getProperties().getAttachAppAuthInfoProperties().isExclude(appId))) {
            request.addHeader(HEADER_IAM_API_APP_TOKEN, apToken);
        }
        if (!(request.containsHeader(HEADER_IAM_API_APP_SECRET) || (apSecret = DWHttpClientProperties.getProperties().getIamApSecret()) == null || apSecret.isEmpty() || DWHttpClientProperties.getProperties().getAttachAppAuthInfoProperties().isExclude(appId))) {
            request.addHeader(HEADER_IAM_API_APP_SECRET, apSecret);
        }
    }

    public static Map<String, String> getIamApiRequiredHeaders() {
        HttpClientResourceBundleProvider resourceBundleProvider;
        Locale locale;
        HttpClientRequestContextProvider requestContextProvider;
        String token;
        HashMap<String, String> requiredHeaders = new HashMap<String, String>();
        String iamApToken = DWHttpClientProperties.getProperties().getIamApToken();
        if (iamApToken.isEmpty()) {
            HttpClientRequestContextProvider requestContextProvider2 = (HttpClientRequestContextProvider)SpringContextUtils.getBean((String)"httpClientRequestContextProvider");
            iamApToken = requestContextProvider2.getAppToken("");
        }
        requiredHeaders.put(HEADER_IAM_API_APP_TOKEN, iamApToken);
        String tokenMode = DWHttpClientProperties.getProperties().getTokenMode();
        if (StringUtils.isNotBlank((CharSequence)tokenMode) && tokenMode.equals(SERVER_HTTP_TOKEN_MODE_IAM) && (token = (requestContextProvider = (HttpClientRequestContextProvider)SpringContextUtils.getBean((String)"httpClientRequestContextProvider")).getToken()) != null && !token.isEmpty()) {
            requiredHeaders.put(HEADER_IAM_API_USER_TOKEN, token);
        }
        if ((locale = (resourceBundleProvider = (HttpClientResourceBundleProvider)SpringContextUtils.getBean((String)"httpClientResourceBundleProvider")).getCurrentLocale()) != null) {
            requiredHeaders.put(HEADER_STANDARD_ACCEPT_LANGUAGE, locale.toLanguageTag());
        }
        return requiredHeaders;
    }
}

