/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.config;

import com.digiwin.http.client.DWHttpClientProperties;
import org.apache.http.client.config.RequestConfig;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DWHttpRequestConfig {
    public static final String GLBOAL_CONFIG_ID = "dw";
    public static final String PROPERTY_PREFIX = "HttpRequestConfig";
    private int connectionRequestTimeout = 20000;
    private int connectTimeout = 60000;
    private int socketTimeout = 30000;

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public RequestConfig convert() {
        return DWHttpRequestConfig.covert(this);
    }

    public static DWHttpRequestConfig createDefault() {
        return DWHttpRequestConfig.create(GLBOAL_CONFIG_ID);
    }

    public static DWHttpRequestConfig create(String appId) {
        DWHttpClientProperties properties = DWHttpClientProperties.getProperties();
        DWHttpRequestConfig config = new DWHttpRequestConfig();
        config.setConnectionRequestTimeout(properties.getConnectionRequestTimeout());
        config.setConnectTimeout(properties.getConnectTimeout());
        config.setSocketTimeout(properties.getSocketTimeout());
        return config;
    }

    public static RequestConfig covert(DWHttpRequestConfig dwRequestConfig) {
        if (dwRequestConfig == null) {
            return RequestConfig.custom().build();
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(dwRequestConfig.getConnectTimeout()).setSocketTimeout(dwRequestConfig.getSocketTimeout()).setConnectionRequestTimeout(dwRequestConfig.getConnectionRequestTimeout()).build();
        return requestConfig;
    }
}

