/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.utils;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.http.client.DWHttpClientProperties;
import com.digiwin.http.client.utils.DWDapApiRouteType;
import com.google.gson.Gson;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;

public class DWURIBuilder
extends URIBuilder {
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";
    public static final String SCHEME_DIGIWIN_APP = "dwapp";
    public static final String SCHEME_DIGIWIN_APP_URL = "dwapp://";

    public DWURIBuilder(String string) throws URISyntaxException {
        super(string);
    }

    public static DWURIBuilder create(String serviceUri) throws URISyntaxException {
        Objects.requireNonNull(serviceUri);
        return new DWURIBuilder(serviceUri);
    }

    public static String getDigiwinAppSchemeUrl(String appId) {
        Objects.requireNonNull(appId);
        return SCHEME_DIGIWIN_APP_URL + appId;
    }

    public static DWURIBuilder create(String appId, String servicePath) throws URISyntaxException {
        boolean servicePathHasSlash;
        Object digiwinAppSchemeUrl = DWURIBuilder.getDigiwinAppSchemeUrl(appId);
        if (servicePath == null) {
            servicePath = "";
        }
        if (!(servicePathHasSlash = servicePath.startsWith("/"))) {
            digiwinAppSchemeUrl = (String)digiwinAppSchemeUrl + "/";
        }
        String uri = (String)digiwinAppSchemeUrl + servicePath;
        return new DWURIBuilder(uri);
    }

    public static DWURIBuilder create(String appId, DWDapApiRouteType routeType, String servicePath) throws MalformedURLException, URISyntaxException {
        Objects.requireNonNull(routeType);
        Objects.requireNonNull(servicePath);
        String path = Paths.get(routeType.getValue(), servicePath).toString();
        servicePath = path.replaceAll("\\\\", "/");
        return DWURIBuilder.create(appId, servicePath);
    }

    public static DWURIBuilder createStandardRouteDapAPI(String appId, String servicePath) throws MalformedURLException, URISyntaxException {
        return DWURIBuilder.create(appId, DWDapApiRouteType.STANDARD, servicePath);
    }

    public static DWURIBuilder createServiceRouteDapAPI(String appId, String servicePath) throws MalformedURLException, URISyntaxException {
        return DWURIBuilder.create(appId, DWDapApiRouteType.SERVICE, servicePath);
    }

    public static DWURIBuilder createServiceRouteDapAPI(String moduleName, String interfaceName, String methodName) throws MalformedURLException, URISyntaxException {
        String currentAppId = DWHttpClientProperties.getProperties().getAppId();
        return DWURIBuilder.createServiceRouteDapAPI(currentAppId, moduleName, interfaceName, methodName);
    }

    public static DWURIBuilder createServiceRouteDapAPI(String appId, String moduleName, String interfaceName, String methodName) throws MalformedURLException, URISyntaxException {
        String serviceUri = String.join((CharSequence)"/", moduleName, interfaceName, methodName);
        return DWURIBuilder.create(appId, DWDapApiRouteType.SERVICE, serviceUri);
    }

    public static DWURIBuilder createServiceRouteRestfulDapAPI(String moduleName, String ... resourceNames) throws MalformedURLException, URISyntaxException {
        String currentAppId = DWHttpClientProperties.getProperties().getAppId();
        return DWURIBuilder.createServiceRouteRestfulDapAPI(currentAppId, moduleName, resourceNames);
    }

    public static DWURIBuilder createServiceRouteRestfulDapAPI(String appId, String moduleName, String ... resourceNames) throws MalformedURLException, URISyntaxException {
        String serviceUri = String.join((CharSequence)"/", moduleName, String.join((CharSequence)"/", resourceNames));
        return DWURIBuilder.create(appId, DWDapApiRouteType.SERVICE, serviceUri);
    }

    public DWURIBuilder addParameter(String param, Object value) {
        Gson gson = DWGsonProvider.getGson();
        String jsonString = value instanceof String ? value.toString() : gson.toJson(value);
        super.addParameter(param, jsonString);
        return this;
    }

    public DWURIBuilder setParameters(Map<String, Object> parameters) {
        if (parameters == null) {
            super.clearParameters();
        } else {
            parameters.entrySet().stream().forEach(item -> this.addParameter((String)item.getKey(), item.getValue()));
        }
        return this;
    }
}

